package com.valor.vod.meta.model.database.ddo.playlist;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * playlist award配置表
 *
 * @author Damon.Gao
 * @date 2021/7/28 17:56
 */
@Entity
@Data
@Table(name = "playlist_award_config")
public class PlaylistAwardConfigDDO implements Serializable {

    private static final long serialVersionUID = 8984622255138171248L;
    @Id
    @Column(name = "id")
    private Integer id;

    @Column(name = "event_base_id")
    private Integer eventBaseId;

    @Column(name = "category_real_name")
    private String categoryRealName;

    @Column(name = "category_show_name")
    private String categoryShowName;

    @Column(name = "event_name")
    private String eventName;

    @Column(name = "category_order")
    private Integer categoryOrder;

    @Column(name = "img_tag")
    private String imgTag;

    @Column(name = "create_user")
    private Integer createUser;

    @Column(name = "create_time", insertable = false, updatable = false)
    private LocalDateTime createTime;

    @Column(name = "update_user")
    private Integer updateUser;

    @Column(name = "update_time", insertable = false, updatable = false)
    private LocalDateTime updateTime;

}
