package com.valor.vod.meta.model.database.ddo.playlist.topicfilm;

import com.google.common.base.Objects;
import com.valor.vod.api.model.constant.EVideoType;
import com.valor.vod.common.database.model.AbstractLMI;
import com.valor.vod.meta.model.database.constants.ETopicType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2016/6/17.
 */
//@Entity
//@Table(name = "playlist_topic_film_media")
//@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class TopicFilmMedia extends AbstractLMI {
    private static final long serialVersionUID = 4625438268855215788L;
    //    @Id
//    @Column(name = "pid")
    private Long pid = -1L;

//    @Id
//    @Column(name = "media_id")
    private Long mediaId = -1L;

//    @Column(name = "topic")
    private int topicType = ETopicType.UNKNOWN.value;


//    @Column(name = "media_type")
    private EVideoType mediaType = EVideoType.UNKNOWN;

//    @Column(name = "pos")
    private int pos = 0;


    public int getTopicType() {
        return topicType;
    }

    public void setTopicType(int topicType) {
        this.topicType = topicType;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }


    public int getPos() {
        return pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public EVideoType getMediaType() {
        return mediaType;
    }

    public void setMediaType(EVideoType mediaType) {
        this.mediaType = mediaType;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TopicFilmMedia that = (TopicFilmMedia) o;

        return Objects.equal(this.pid, that.pid) &&
            Objects.equal(this.mediaId, that.mediaId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(pid, mediaId);
    }
}
