package com.valor.vod.meta.model.database.dto;

import com.google.common.collect.Sets;
import com.valor.vod.meta.model.database.ddo.person.*;

import java.util.Objects;
import java.util.Set;

/**
 * Created by Frank.Huang on 2016/5/7.
 */
public class PersonDto {
    private Person person;
    private PersonLocale locale;
    //    private AbstractPersonLocale mlLocale;
    private Set<AbstractPersonLocale> mlLocales;
    private Set<PersonKnowFor> knowFors = Sets.newHashSet();
    private Set<PersonAward> awards = Sets.newHashSet();
    private Set<PersonFilmography2> filmographies = Sets.newHashSet();
    private PersonStarMeter personStarMeter;
    private Set<PersonTag> personTags = Sets.newHashSet();

    public Person getPerson() {
        return person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public PersonLocale getLocale() {
        return locale;
    }

    public void setLocale(PersonLocale locale) {
        this.locale = locale;
    }

    public Set<PersonKnowFor> getKnowFors() {
        return knowFors;
    }

    public void setKnowFors(Set<PersonKnowFor> knowFors) {
        this.knowFors = knowFors;
    }


    public Set<PersonTag> getPersonTags() {
        return personTags;
    }

    public void setPersonTags(Set<PersonTag> personTags) {
        this.personTags = personTags;
    }

    public boolean isValid() {
        if (Objects.isNull(person)) {
            return false;
        }

        return true;
    }

    public Set<PersonAward> getAwards() {
        return awards;
    }

    public void setAwards(Set<PersonAward> awards) {
        this.awards = awards;
    }

    public Set<PersonFilmography2> getFilmographies() {
        return filmographies;
    }

    public void setFilmographies(Set<PersonFilmography2> filmographies) {
        this.filmographies = filmographies;
    }

    public Set<AbstractPersonLocale> getMlLocales() {
        return mlLocales;
    }

    public void setMlLocales(Set<AbstractPersonLocale> mlLocales) {
        this.mlLocales = mlLocales;
    }

    public PersonStarMeter getPersonStarMeter() {
        return personStarMeter;
    }

    public void setPersonStarMeter(PersonStarMeter personStarMeter) {
        this.personStarMeter = personStarMeter;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PersonDto that = (PersonDto) o;

        return com.google.common.base.Objects.equal(this.person, that.person);
    }

    @Override
    public int hashCode() {
        return com.google.common.base.Objects.hashCode(person);
    }
}
