/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.model.database.dao;

import com.google.common.collect.ImmutableMap;
import com.valor.vod.meta.model.database.dao.AbstractMetaBaseDao;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistNodeDDO;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistNodeVersionDDO;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(value="metaTransactionManager")
public class PlaylistVersionDao
extends AbstractMetaBaseDao {
    public PlaylistNodeVersionDDO getLatestValid(Long playlistNodeId) {
        NativeQuery query = this.currentSession().createNativeQuery("select * from playlist_node_version where playlist_node_id =:playlistNodeId and status = 1 order by version desc limit 1", PlaylistNodeVersionDDO.class);
        query.setParameter("playlistNodeId", (Object)playlistNodeId);
        return (PlaylistNodeVersionDDO)query.uniqueResult();
    }

    public boolean checkProductValid(Long playlistNodeId) {
        NativeQuery query = this.currentSession().createNativeQuery("select root_node_id from portal_product where root_node_id =:playlistNodeId and status = 'ENABLE'");
        query.setParameter("playlistNodeId", (Object)playlistNodeId);
        return !query.list().isEmpty();
    }

    public List<PlaylistNodeVersionDDO> getList(Long playlistNodeId) {
        List list = this.getListDataIn(false, PlaylistNodeVersionDDO.class, (Map<String, Object>)ImmutableMap.of((Object)"playlistNodeId", (Object)playlistNodeId));
        list.sort((o1, o2) -> (int)(o2.getVersion() - o1.getVersion()));
        return list;
    }

    public List<PlaylistNodeDDO> getParentNodes(long playlistId) {
        NativeQuery query = this.currentSession().createNativeQuery("select * from playlist_node where vms_id =:vmsId", PlaylistNodeDDO.class);
        query.setParameter("vmsId", (Object)playlistId);
        return query.list();
    }

    public List<Long> getTreeRootNodeIds(List<Long> nodeIdList) {
        Session session = this.currentSession();
        NativeQuery query = session.createNativeQuery("select distinct root_node_id from portal_product where root_node_id in :nodeIdList");
        query.setParameterList("nodeIdList", nodeIdList);
        List list = query.list();
        return list.stream().filter(e -> Objects.nonNull(e)).map(e -> Long.valueOf(e.toString())).collect(Collectors.toList());
    }
}

