/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.model.service;

import com.google.common.collect.Maps;
import com.valor.vod.meta.model.database.dao.MetaDao;
import com.valor.vod.meta.model.database.ddo.base.CountryLangDict;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CountryLangService {
    private static final Logger logger = LoggerFactory.getLogger(CountryLangService.class);
    @Autowired
    private MetaDao metaDao;
    private Map<String, String> langCountryMap = Maps.newHashMap();

    @PostConstruct
    public void load() {
        Set countryLangSet = this.metaDao.getSetData(false, CountryLangDict.class, null);
        if (!countryLangSet.isEmpty()) {
            countryLangSet.forEach(e -> this.langCountryMap.put(e.getLanguageISO9361(), e.getCountryName()));
            logger.info("Load [{}] country language from database", (Object)this.langCountryMap.size());
        }
    }

    public String getCountry(String lang) {
        return this.langCountryMap.getOrDefault(lang, "");
    }
}

