/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.model.service;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.valor.vod.common.tools.type.CollectionUtils;
import com.valor.vod.meta.model.database.dao.MetaDao;
import com.valor.vod.meta.model.database.ddo.base.CountryAlias;
import com.valor.vod.meta.model.database.ddo.base.CountryDict;
import com.valor.vod.meta.model.database.ddo.media.common.Country;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="CountryService")
public class CountryService {
    private static final Logger logger = LoggerFactory.getLogger(CountryService.class);
    private static Map<String, String> alias2nameMap = Maps.newConcurrentMap();
    private static Map<String, String> code2nameMap = Maps.newConcurrentMap();
    private static Map<String, String> name2codeMap = Maps.newConcurrentMap();
    private static Map<Long, String> idCodeMap = Maps.newConcurrentMap();
    private static Map<String, Long> codeIdMap = Maps.newConcurrentMap();
    private static boolean enable = true;
    @Autowired
    private MetaDao metaDao;

    public static void setEnable(boolean enable) {
        CountryService.enable = enable;
    }

    @PostConstruct
    public void loadFromDB() {
        Set countryAliases;
        Set countries;
        if (!enable) {
            logger.info("CountryService is DISABLE");
            return;
        }
        Set countryDicts = this.metaDao.getSetData(false, CountryDict.class, null);
        if (!countryDicts.isEmpty()) {
            countryDicts.forEach(e -> {
                code2nameMap.put(e.getCode().toLowerCase(), e.getName());
                name2codeMap.put(e.getName(), e.getCode().toLowerCase());
            });
            logger.info("Load [{}] countryDict from database", (Object)countryDicts.size());
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)(countries = this.metaDao.getSetData(true, Country.class, null)))) {
            countries.forEach(e -> {
                idCodeMap.put(e.getId(), e.getCode());
                codeIdMap.put(e.getCode().toLowerCase(), e.getId());
            });
            logger.info("Load [{}] Country from database", (Object)idCodeMap.size());
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)(countryAliases = this.metaDao.getSetData(true, CountryAlias.class, null)))) {
            countryAliases.forEach(e -> alias2nameMap.put(e.getAlias(), e.getName()));
            logger.info("Load [{}] countryAliases from database", (Object)countryAliases.size());
        }
    }

    @PreDestroy
    public void storeToDB() {
        if (!code2nameMap.isEmpty()) {
            HashSet countries = Sets.newHashSet();
            code2nameMap.forEach((k, v) -> {
                CountryDict country = new CountryDict();
                country.setCode((String)k);
                country.setName((String)v);
                countries.add(country);
            });
            if (!countries.isEmpty()) {
                this.metaDao.storeAll(countries);
            }
        }
    }

    public String getName(String code) {
        return code2nameMap.getOrDefault(code.toLowerCase(), "");
    }

    public String getNameByAlias(String alias) {
        return alias2nameMap.getOrDefault(alias, alias);
    }

    public String getCode(String name) {
        return name2codeMap.getOrDefault(this.getNameByAlias(name), "");
    }

    public String getCodeById(Long id) {
        return idCodeMap.getOrDefault(id, "");
    }

    public String getNameById(Long id) {
        String code = this.getCodeById(id);
        if (Strings.isNullOrEmpty((String)code)) {
            return "";
        }
        return this.getName(code);
    }

    public void AddCountry(Map<String, String> countryMap) {
        if (countryMap != null) {
            countryMap.forEach((k, v) -> this.AddCountry((String)k, (String)v));
        }
    }

    public void AddCountry(String code, String name) {
        CountryDict country = null;
        String oldName = code2nameMap.get(code);
        if (Strings.isNullOrEmpty((String)oldName)) {
            country = new CountryDict();
            country.setCode(code);
            country.setName(name);
        } else if (oldName.compareTo(name) != 0) {
            country = new CountryDict();
            country.setCode(code);
            country.setName(name);
        }
        code2nameMap.put(code, name);
        if (country != null) {
            this.metaDao.storeEntity(country);
        }
    }

    public boolean isInvalidCountry(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return false;
        }
        if (!Strings.isNullOrEmpty((String)this.getName(name.trim()))) {
            return true;
        }
        return !Strings.isNullOrEmpty((String)this.getCode(name.trim()));
    }

    public long getIdByCode(String code) {
        if (!Strings.isNullOrEmpty((String)code)) {
            return codeIdMap.getOrDefault(code.toLowerCase(), 0L);
        }
        return 0L;
    }
}

