package com.valor.vod.common.spring.cache;

import common.config.tools.config.ConfigTools3;

public class CacheConfig {

    public static final String CACHE_SHOW_LOG = "cache.show.log";
    public static final String CACHE_SHOW_STAT_LOG = "cache.show.stat.log";
    public static final String CACHE_ALLOW_NULL_VALUE = "cache.allow.null.value";

    public static final String CACHE_L1_USED = "cache.l1.used";
    public static final String CACHE_L1_CONCURRENCY_LEVEL = "cache.l1.concurrency.level";
    public static final String CACHE_L1_MAXIMUM_SIZE = "cache.l1.maximum.size";
    public static final String CACHE_L1_EXPIRE_SECOND_AFTER_WRITE = "cache.l1.expire.second.after.write";
    public static final String CACHE_L1_EXPIRE_SECOND_AFTER_ACCESS = "cache.l1.expire.second.after.access";

    public static final String CACHE_L2_USED = "cache.l2.used";
    public static final String CACHE_L2_USE_NAME_AS_PREFIX_ = "cache.l2.use.name.as.prefix";
    public static final String CACHE_L2_EXPIRE_SECOND_AFTER_WRITE = "cache.l2.expire.second.after.write";

    private boolean cacheShowLog = ConfigTools3.getBoolean(CACHE_SHOW_LOG, false);
    private boolean cacheShowStatLog = ConfigTools3.getBoolean(CACHE_SHOW_STAT_LOG, false);
    private boolean cacheAllowNullValue = ConfigTools3.getBoolean(CACHE_ALLOW_NULL_VALUE, true);

    private boolean cacheL1Used = ConfigTools3.getBoolean(CACHE_L1_USED, true);
    private int cacheL1ConcurrencyLevel = ConfigTools3.getInt(CACHE_L1_CONCURRENCY_LEVEL, 5);
    private long cacheL1MaximumSize = ConfigTools3.getLong(CACHE_L1_MAXIMUM_SIZE, 50000L);
    private long cacheL1ExpireSecondAfterWrite = ConfigTools3.getLong(CACHE_L1_EXPIRE_SECOND_AFTER_WRITE, 600L);
    private long cacheL1ExpireSecondAfterAccess = ConfigTools3.getLong(CACHE_L1_EXPIRE_SECOND_AFTER_ACCESS, 120L);

    private boolean cacheL2Used = ConfigTools3.getBoolean(CACHE_L2_USED, true);
    private boolean cacheL2UsePrefix = ConfigTools3.getBoolean(CACHE_L2_USE_NAME_AS_PREFIX_, true);
    private long cacheL2ExpireSecondAfterWrite = ConfigTools3.getLong(CACHE_L2_EXPIRE_SECOND_AFTER_WRITE, 7200L);

    public CacheConfig(String cacheName) {
        this.cacheShowLog = ConfigTools3.getBoolean(buildPropertyKey(CACHE_SHOW_LOG, cacheName), cacheShowLog);
        this.cacheShowStatLog = ConfigTools3.getBoolean(buildPropertyKey(CACHE_SHOW_STAT_LOG, cacheName), cacheShowStatLog);
        this.cacheAllowNullValue = ConfigTools3.getBoolean(buildPropertyKey(CACHE_ALLOW_NULL_VALUE, cacheName), cacheAllowNullValue);

        this.cacheL1Used = ConfigTools3.getBoolean(buildPropertyKey(CACHE_L1_USED, cacheName), cacheL1Used);
        this.cacheL1ConcurrencyLevel = ConfigTools3.getInt(
            buildPropertyKey(CACHE_L1_CONCURRENCY_LEVEL, cacheName), cacheL1ConcurrencyLevel);
        this.cacheL1MaximumSize = ConfigTools3.getLong(
            buildPropertyKey(CACHE_L1_MAXIMUM_SIZE, cacheName), cacheL1MaximumSize);
        this.cacheL1ExpireSecondAfterWrite = ConfigTools3.getLong(
            buildPropertyKey(CACHE_L1_EXPIRE_SECOND_AFTER_WRITE, cacheName), cacheL1ExpireSecondAfterWrite);
        this.cacheL1ExpireSecondAfterAccess = ConfigTools3.getLong(
            buildPropertyKey(CACHE_L1_EXPIRE_SECOND_AFTER_ACCESS, cacheName), cacheL1ExpireSecondAfterAccess);

        this.cacheL2Used = ConfigTools3.getBoolean(buildPropertyKey(CACHE_L2_USED, cacheName), cacheL2Used);
        this.cacheL2UsePrefix = ConfigTools3.getBoolean(
            buildPropertyKey(CACHE_L2_USE_NAME_AS_PREFIX_, cacheName), cacheL2UsePrefix);
        this.cacheL2ExpireSecondAfterWrite = ConfigTools3.getLong(
            buildPropertyKey(CACHE_L2_EXPIRE_SECOND_AFTER_WRITE, cacheName), cacheL2ExpireSecondAfterWrite);
    }

    private String buildPropertyKey(String basicKey, String extraKey) {
        return extraKey + "." + basicKey;
    }

    public boolean isCacheUsed() {
        return isCacheL1Used() || isCacheL2Used();
    }

    public boolean isCacheAllowNullValue() {
        return cacheAllowNullValue;
    }

    public void setCacheAllowNullValue(boolean cacheAllowNullValue) {
        this.cacheAllowNullValue = cacheAllowNullValue;
    }

    public boolean isCacheL1Used() {
        return cacheL1Used;
    }

    public void setCacheL1Used(boolean cacheL1Used) {
        this.cacheL1Used = cacheL1Used;
    }

    public int getCacheL1ConcurrencyLevel() {
        return cacheL1ConcurrencyLevel;
    }

    public void setCacheL1ConcurrencyLevel(int cacheL1ConcurrencyLevel) {
        this.cacheL1ConcurrencyLevel = cacheL1ConcurrencyLevel;
    }

    public long getCacheL1MaximumSize() {
        return cacheL1MaximumSize;
    }

    public void setCacheL1MaximumSize(long cacheL1MaximumSize) {
        this.cacheL1MaximumSize = cacheL1MaximumSize;
    }

    public long getCacheL1ExpireSecondAfterWrite() {
        return cacheL1ExpireSecondAfterWrite;
    }

    public void setCacheL1ExpireSecondAfterWrite(long cacheL1ExpireSecondAfterWrite) {
        this.cacheL1ExpireSecondAfterWrite = cacheL1ExpireSecondAfterWrite;
    }

    public long getCacheL1ExpireSecondAfterAccess() {
        return cacheL1ExpireSecondAfterAccess;
    }

    public void setCacheL1ExpireSecondAfterAccess(long cacheL1ExpireSecondAfterAccess) {
        this.cacheL1ExpireSecondAfterAccess = cacheL1ExpireSecondAfterAccess;
    }

    public boolean isCacheL2UsePrefix() {
        return cacheL2UsePrefix;
    }

    public void setCacheL2UsePrefix(boolean cacheL2UsePrefix) {
        this.cacheL2UsePrefix = cacheL2UsePrefix;
    }

    public long getCacheL2ExpireSecondAfterWrite() {
        return cacheL2ExpireSecondAfterWrite;
    }

    public void setCacheL2ExpireSecondAfterWrite(long cacheL2ExpireSecondAfterWrite) {
        this.cacheL2ExpireSecondAfterWrite = cacheL2ExpireSecondAfterWrite;
    }

    public boolean isCacheL2Used() {
        return cacheL2Used;
    }

    public void setCacheL2Used(boolean cacheL2Used) {
        this.cacheL2Used = cacheL2Used;
    }

    public boolean isCacheShowLog() {
        return cacheShowLog;
    }

    public void setCacheShowLog(boolean cacheShowLog) {
        this.cacheShowLog = cacheShowLog;
    }

    public boolean isCacheShowStatLog() {
        return cacheShowStatLog;
    }

    public void setCacheShowStatLog(boolean cacheShowStatLog) {
        this.cacheShowStatLog = cacheShowStatLog;
    }

    @Override
    public String toString() {
        return "CacheConfig{" +
            "cacheShowLog=" + cacheShowLog +
            ", cacheShowStatLog=" + cacheShowStatLog +
            ", cacheAllowNullValue=" + cacheAllowNullValue +
            ", cacheL1Used=" + cacheL1Used +
            ", cacheL1ConcurrencyLevel=" + cacheL1ConcurrencyLevel +
            ", cacheL1MaximumSize=" + cacheL1MaximumSize +
            ", cacheL1ExpireSecondAfterWrite=" + cacheL1ExpireSecondAfterWrite +
            ", cacheL1ExpireSecondAfterAccess=" + cacheL1ExpireSecondAfterAccess +
            ", cacheL2Used=" + cacheL2Used +
            ", cacheL2UsePrefix=" + cacheL2UsePrefix +
            ", cacheL2ExpireSecondAfterWrite=" + cacheL2ExpireSecondAfterWrite +
            '}';
    }
}
