/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.spring.cache;

import common.config.tools.config.ConfigTools3;

public class CacheConfig {
    public static final String CACHE_SHOW_LOG = "cache.show.log";
    public static final String CACHE_SHOW_STAT_LOG = "cache.show.stat.log";
    public static final String CACHE_ALLOW_NULL_VALUE = "cache.allow.null.value";
    public static final String CACHE_L1_USED = "cache.l1.used";
    public static final String CACHE_L1_CONCURRENCY_LEVEL = "cache.l1.concurrency.level";
    public static final String CACHE_L1_MAXIMUM_SIZE = "cache.l1.maximum.size";
    public static final String CACHE_L1_EXPIRE_SECOND_AFTER_WRITE = "cache.l1.expire.second.after.write";
    public static final String CACHE_L1_EXPIRE_SECOND_AFTER_ACCESS = "cache.l1.expire.second.after.access";
    public static final String CACHE_L2_USED = "cache.l2.used";
    public static final String CACHE_L2_USE_NAME_AS_PREFIX_ = "cache.l2.use.name.as.prefix";
    public static final String CACHE_L2_EXPIRE_SECOND_AFTER_WRITE = "cache.l2.expire.second.after.write";
    private boolean cacheShowLog = ConfigTools3.getBoolean((String)"cache.show.log", (boolean)false);
    private boolean cacheShowStatLog = ConfigTools3.getBoolean((String)"cache.show.stat.log", (boolean)false);
    private boolean cacheAllowNullValue = ConfigTools3.getBoolean((String)"cache.allow.null.value", (boolean)true);
    private boolean cacheL1Used = ConfigTools3.getBoolean((String)"cache.l1.used", (boolean)true);
    private int cacheL1ConcurrencyLevel = ConfigTools3.getInt((String)"cache.l1.concurrency.level", (Integer)5);
    private long cacheL1MaximumSize = ConfigTools3.getLong((String)"cache.l1.maximum.size", (Long)50000L);
    private long cacheL1ExpireSecondAfterWrite = ConfigTools3.getLong((String)"cache.l1.expire.second.after.write", (Long)600L);
    private long cacheL1ExpireSecondAfterAccess = ConfigTools3.getLong((String)"cache.l1.expire.second.after.access", (Long)120L);
    private boolean cacheL2Used = ConfigTools3.getBoolean((String)"cache.l2.used", (boolean)true);
    private boolean cacheL2UsePrefix = ConfigTools3.getBoolean((String)"cache.l2.use.name.as.prefix", (boolean)true);
    private long cacheL2ExpireSecondAfterWrite = ConfigTools3.getLong((String)"cache.l2.expire.second.after.write", (Long)7200L);

    public CacheConfig(String cacheName) {
        this.cacheShowLog = ConfigTools3.getBoolean((String)this.buildPropertyKey(CACHE_SHOW_LOG, cacheName), (boolean)this.cacheShowLog);
        this.cacheShowStatLog = ConfigTools3.getBoolean((String)this.buildPropertyKey(CACHE_SHOW_STAT_LOG, cacheName), (boolean)this.cacheShowStatLog);
        this.cacheAllowNullValue = ConfigTools3.getBoolean((String)this.buildPropertyKey(CACHE_ALLOW_NULL_VALUE, cacheName), (boolean)this.cacheAllowNullValue);
        this.cacheL1Used = ConfigTools3.getBoolean((String)this.buildPropertyKey(CACHE_L1_USED, cacheName), (boolean)this.cacheL1Used);
        this.cacheL1ConcurrencyLevel = ConfigTools3.getInt((String)this.buildPropertyKey(CACHE_L1_CONCURRENCY_LEVEL, cacheName), (Integer)this.cacheL1ConcurrencyLevel);
        this.cacheL1MaximumSize = ConfigTools3.getLong((String)this.buildPropertyKey(CACHE_L1_MAXIMUM_SIZE, cacheName), (Long)this.cacheL1MaximumSize);
        this.cacheL1ExpireSecondAfterWrite = ConfigTools3.getLong((String)this.buildPropertyKey(CACHE_L1_EXPIRE_SECOND_AFTER_WRITE, cacheName), (Long)this.cacheL1ExpireSecondAfterWrite);
        this.cacheL1ExpireSecondAfterAccess = ConfigTools3.getLong((String)this.buildPropertyKey(CACHE_L1_EXPIRE_SECOND_AFTER_ACCESS, cacheName), (Long)this.cacheL1ExpireSecondAfterAccess);
        this.cacheL2Used = ConfigTools3.getBoolean((String)this.buildPropertyKey(CACHE_L2_USED, cacheName), (boolean)this.cacheL2Used);
        this.cacheL2UsePrefix = ConfigTools3.getBoolean((String)this.buildPropertyKey(CACHE_L2_USE_NAME_AS_PREFIX_, cacheName), (boolean)this.cacheL2UsePrefix);
        this.cacheL2ExpireSecondAfterWrite = ConfigTools3.getLong((String)this.buildPropertyKey(CACHE_L2_EXPIRE_SECOND_AFTER_WRITE, cacheName), (Long)this.cacheL2ExpireSecondAfterWrite);
    }

    private String buildPropertyKey(String basicKey, String extraKey) {
        return extraKey + "." + basicKey;
    }

    public boolean isCacheUsed() {
        return this.isCacheL1Used() || this.isCacheL2Used();
    }

    public boolean isCacheAllowNullValue() {
        return this.cacheAllowNullValue;
    }

    public void setCacheAllowNullValue(boolean cacheAllowNullValue) {
        this.cacheAllowNullValue = cacheAllowNullValue;
    }

    public boolean isCacheL1Used() {
        return this.cacheL1Used;
    }

    public void setCacheL1Used(boolean cacheL1Used) {
        this.cacheL1Used = cacheL1Used;
    }

    public int getCacheL1ConcurrencyLevel() {
        return this.cacheL1ConcurrencyLevel;
    }

    public void setCacheL1ConcurrencyLevel(int cacheL1ConcurrencyLevel) {
        this.cacheL1ConcurrencyLevel = cacheL1ConcurrencyLevel;
    }

    public long getCacheL1MaximumSize() {
        return this.cacheL1MaximumSize;
    }

    public void setCacheL1MaximumSize(long cacheL1MaximumSize) {
        this.cacheL1MaximumSize = cacheL1MaximumSize;
    }

    public long getCacheL1ExpireSecondAfterWrite() {
        return this.cacheL1ExpireSecondAfterWrite;
    }

    public void setCacheL1ExpireSecondAfterWrite(long cacheL1ExpireSecondAfterWrite) {
        this.cacheL1ExpireSecondAfterWrite = cacheL1ExpireSecondAfterWrite;
    }

    public long getCacheL1ExpireSecondAfterAccess() {
        return this.cacheL1ExpireSecondAfterAccess;
    }

    public void setCacheL1ExpireSecondAfterAccess(long cacheL1ExpireSecondAfterAccess) {
        this.cacheL1ExpireSecondAfterAccess = cacheL1ExpireSecondAfterAccess;
    }

    public boolean isCacheL2UsePrefix() {
        return this.cacheL2UsePrefix;
    }

    public void setCacheL2UsePrefix(boolean cacheL2UsePrefix) {
        this.cacheL2UsePrefix = cacheL2UsePrefix;
    }

    public long getCacheL2ExpireSecondAfterWrite() {
        return this.cacheL2ExpireSecondAfterWrite;
    }

    public void setCacheL2ExpireSecondAfterWrite(long cacheL2ExpireSecondAfterWrite) {
        this.cacheL2ExpireSecondAfterWrite = cacheL2ExpireSecondAfterWrite;
    }

    public boolean isCacheL2Used() {
        return this.cacheL2Used;
    }

    public void setCacheL2Used(boolean cacheL2Used) {
        this.cacheL2Used = cacheL2Used;
    }

    public boolean isCacheShowLog() {
        return this.cacheShowLog;
    }

    public void setCacheShowLog(boolean cacheShowLog) {
        this.cacheShowLog = cacheShowLog;
    }

    public boolean isCacheShowStatLog() {
        return this.cacheShowStatLog;
    }

    public void setCacheShowStatLog(boolean cacheShowStatLog) {
        this.cacheShowStatLog = cacheShowStatLog;
    }

    public String toString() {
        return "CacheConfig{cacheShowLog=" + this.cacheShowLog + ", cacheShowStatLog=" + this.cacheShowStatLog + ", cacheAllowNullValue=" + this.cacheAllowNullValue + ", cacheL1Used=" + this.cacheL1Used + ", cacheL1ConcurrencyLevel=" + this.cacheL1ConcurrencyLevel + ", cacheL1MaximumSize=" + this.cacheL1MaximumSize + ", cacheL1ExpireSecondAfterWrite=" + this.cacheL1ExpireSecondAfterWrite + ", cacheL1ExpireSecondAfterAccess=" + this.cacheL1ExpireSecondAfterAccess + ", cacheL2Used=" + this.cacheL2Used + ", cacheL2UsePrefix=" + this.cacheL2UsePrefix + ", cacheL2ExpireSecondAfterWrite=" + this.cacheL2ExpireSecondAfterWrite + '}';
    }
}

