/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.spring.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.valor.vod.common.spring.cache.CacheConfig;
import com.valor.vod.common.spring.cache.CustomRedisCache;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;

public class MultiLevelCache
extends AbstractValueAdaptingCache {
    private static final Logger logger = LoggerFactory.getLogger(MultiLevelCache.class);
    private CacheConfig cacheConfig;
    private String cacheName;
    private Cache cacheL1;
    private Cache cacheL2;

    public MultiLevelCache(String name, RedisConnectionFactory redisConnectionFactory, CacheConfig cacheConfig) {
        super(cacheConfig.isCacheAllowNullValue());
        this.cacheName = name;
        this.cacheConfig = cacheConfig;
        if (cacheConfig.isCacheL1Used()) {
            com.github.benmanes.caffeine.cache.Cache caffeineCache = Caffeine.newBuilder().softValues().maximumSize(cacheConfig.getCacheL1MaximumSize()).expireAfterWrite(cacheConfig.getCacheL1ExpireSecondAfterWrite(), TimeUnit.SECONDS).expireAfterAccess(cacheConfig.getCacheL1ExpireSecondAfterAccess(), TimeUnit.SECONDS).recordStats().build();
            this.cacheL1 = new CaffeineCache(name, caffeineCache, cacheConfig.isCacheAllowNullValue());
        }
        if (cacheConfig.isCacheL2Used()) {
            RedisCacheWriter cacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory);
            RedisCacheConfiguration redisConfig = this.getRedisCacheConfiguration(name, cacheConfig);
            this.cacheL2 = new CustomRedisCache(name, cacheWriter, redisConfig);
        }
        if (cacheConfig.isCacheL1Used() || cacheConfig.isCacheL2Used()) {
            logger.info("[Cache Manager] Create a new cache[{}] with Config[{}]", (Object)name, (Object)cacheConfig);
        }
    }

    private RedisCacheConfiguration getRedisCacheConfiguration(String name, CacheConfig cacheConfig) {
        RedisCacheConfiguration redisConfig = RedisCacheConfiguration.defaultCacheConfig();
        redisConfig = cacheConfig.isCacheL2UsePrefix() ? redisConfig.prefixCacheNameWith(name) : redisConfig.disableKeyPrefix();
        redisConfig = redisConfig.entryTtl(Duration.ofSeconds(cacheConfig.getCacheL2ExpireSecondAfterWrite()));
        if (!cacheConfig.isCacheAllowNullValue()) {
            redisConfig = redisConfig.disableCachingNullValues();
        }
        redisConfig = redisConfig.serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer()));
        return redisConfig;
    }

    protected Object lookup(Object key) {
        if (!this.cacheConfig.isCacheUsed()) {
            return null;
        }
        Cache.ValueWrapper valueWrapper = null;
        if (this.cacheConfig.isCacheL1Used()) {
            valueWrapper = this.cacheL1.get(key);
        }
        if (valueWrapper != null) {
            Object value = valueWrapper.get();
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE LOOKUP] Hit Guava Cache.CACHE[{}],KEY[{}],VALUE[{}]", new Object[]{this.cacheName, key, value});
            }
            return value;
        }
        if (this.cacheConfig.isCacheL2Used()) {
            valueWrapper = this.cacheL2.get(key);
        }
        if (valueWrapper != null) {
            Object value = valueWrapper.get();
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE LOOKUP] Hit Redis Cache.CACHE[{}],KEY[{}],VALUE[{}]", new Object[]{this.cacheName, key, value});
            }
            return value;
        }
        if (this.cacheConfig.isCacheShowLog()) {
            logger.info("[CACHE LOOKUP] Cache miss.CACHE[{}],KEY[{}]", (Object)this.cacheName, key);
        }
        return null;
    }

    public String getName() {
        return this.cacheName;
    }

    public Object getNativeCache() {
        return this;
    }

    public Cache.ValueWrapper get(Object key) {
        if (!this.cacheConfig.isCacheUsed()) {
            return null;
        }
        Cache.ValueWrapper wrapper = null;
        if (this.cacheConfig.isCacheL1Used()) {
            wrapper = this.cacheL1.get(key);
        }
        if (wrapper != null) {
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE GET] Hit Guava Cache.CACHE[{}],KEY[{}],VALUE[{}]", new Object[]{this.cacheName, key, wrapper.get()});
            }
            return wrapper;
        }
        if (this.cacheConfig.isCacheL2Used()) {
            wrapper = this.cacheL2.get(key);
        }
        if (wrapper != null) {
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE GET] Hit Redis Cache.CACHE[{}],KEY[{}],VALUE[{}]", new Object[]{this.cacheName, key, wrapper.get()});
            }
            if (this.cacheConfig.isCacheL1Used()) {
                this.cacheL1.put(key, wrapper.get());
                if (this.cacheConfig.isCacheShowLog()) {
                    logger.info("[CACHE GET] Hit Redis Cache, Update Guava Cache.CACHE[{}],KEY[{}],VALUE[{}]", new Object[]{this.cacheName, key, wrapper.get()});
                }
            }
            return wrapper;
        }
        if (this.cacheConfig.isCacheShowLog()) {
            logger.info("[CACHE GET] Cache miss.CACHE[{}],KEY[{}]", (Object)this.cacheName, key);
        }
        return null;
    }

    public <T> T get(Object key, Class<T> type) {
        if (!this.cacheConfig.isCacheUsed()) {
            return null;
        }
        Object value = null;
        if (this.cacheConfig.isCacheL1Used()) {
            value = this.cacheL1.get(key, type);
        }
        if (value != null) {
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE GET] Hit Guava Cache.CACHE[{}],KEY[{}],VALUE[{}]", new Object[]{this.cacheName, key, value});
            }
            return (T)value;
        }
        if (this.cacheConfig.isCacheL2Used()) {
            value = this.cacheL2.get(key, type);
        }
        if (value != null) {
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE GET] Hit Redis Cache.CACHE[{}],KEY[{}],VALUE[{}]", new Object[]{this.cacheName, key, value});
            }
            if (this.cacheConfig.isCacheL1Used()) {
                this.cacheL1.put(key, value);
                if (this.cacheConfig.isCacheShowLog()) {
                    logger.info("[CACHE GET] Hit Redis Cache, Update Guava Cache.CACHE[{}],KEY[{}],VALUE[{}]", new Object[]{this.cacheName, key, value});
                }
            }
            return (T)value;
        }
        if (this.cacheConfig.isCacheShowLog()) {
            logger.info("[CACHE GET] Cache miss.CACHE[{}],KEY[{}]", (Object)this.cacheName, key);
        }
        return null;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        if (!this.cacheConfig.isCacheUsed()) {
            return null;
        }
        Object value = null;
        if (this.cacheConfig.isCacheL1Used()) {
            value = this.cacheL1.get(key, valueLoader);
        }
        if (value != null) {
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE GET] Hit Guava Cache.CACHE[{}],KEY[{}],VALUE[{}]", new Object[]{this.cacheName, key, value});
            }
            return (T)value;
        }
        if (this.cacheConfig.isCacheL2Used()) {
            value = this.cacheL2.get(key, valueLoader);
        }
        if (value != null) {
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE GET] Hit Redis Cache.CACHE[{}],KEY[{}],VALUE[{}]", new Object[]{this.cacheName, key, value});
            }
            return (T)value;
        }
        if (this.cacheConfig.isCacheShowLog()) {
            logger.info("[CACHE GET] Cache miss.CACHE[{}],KEY[{}]", (Object)this.cacheName, key);
        }
        return null;
    }

    public void put(Object key, Object value) {
        if (this.cacheConfig.isCacheL1Used()) {
            this.cacheL1.put(key, value);
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE PUT] Set Guava Cache.CACHE[{}],KEY[{}],VALUE[{}]", new Object[]{this.cacheName, key, value});
            }
        }
        if (this.cacheConfig.isCacheL2Used()) {
            this.cacheL2.put(key, value);
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE PUT] Set Redis Cache.CACHE[{}],KEY[{}],VALUE[{}]", new Object[]{this.cacheName, key, value});
            }
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        if (this.cacheConfig.isCacheL1Used()) {
            this.cacheL1.putIfAbsent(key, value);
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE PUT IF ABSENT] Set Guava Cache.CACHE[{}],KEY[{}],VALUE[{}]", new Object[]{this.cacheName, key, value});
            }
        }
        if (this.cacheConfig.isCacheL2Used()) {
            this.cacheL2.putIfAbsent(key, value);
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE PUT IF ABSENT] Set Redis Cache.CACHE[{}],KEY[{}],VALUE[{}]", new Object[]{this.cacheName, key, value});
            }
        }
        return null;
    }

    public void evict(Object key) {
        if (this.cacheConfig.isCacheL2Used()) {
            this.cacheL2.evict(key);
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE EVICT] Remove Guava Cache.CACHE[{}],KEY[{}]", (Object)this.cacheName, key);
            }
        }
        if (this.cacheConfig.isCacheL1Used()) {
            this.cacheL1.evict(key);
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE EVICT] Remove Redis Cache.CACHE[{}],KEY[{}]", (Object)this.cacheName, key);
            }
        }
    }

    public void clear() {
        if (this.cacheConfig.isCacheL2Used()) {
            this.cacheL2.clear();
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE EVICT] Clear Guava Cache.CACHE[{}]", (Object)this.cacheName);
            }
        }
        if (this.cacheConfig.isCacheL1Used()) {
            this.cacheL1.clear();
            if (this.cacheConfig.isCacheShowLog()) {
                logger.info("[CACHE EVICT] Clear Guava Cache.CACHE[{}]", (Object)this.cacheName);
            }
        }
    }

    public Cache getCacheL1() {
        return this.cacheL1;
    }

    public void setCacheL1(Cache cacheL1) {
        this.cacheL1 = cacheL1;
    }

    public Cache getCacheL2() {
        return this.cacheL2;
    }

    public void setCacheL2(Cache cacheL2) {
        this.cacheL2 = cacheL2;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public void setCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }
}

