package com.valor.vod.user.model.database.ddo;


import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.*;

@Entity
@Table(name = "area")
public class AreaDdo extends AbstractLMI {

    private static final long serialVersionUID = -8799810582444470454L;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private Integer id;

    @Column(name = "area_id", length = 8, unique = true)
    private String areaId;

    @Column(name = "area_code", length = 8)
    private String areaCode;


    @Column(name = "area_name", length = 32)
    private String areaName;

    @Column(name = "sort_no", length = 8)
    private Integer sortNo;

    @Column(name = "country", length = 32)
    private String country;

    @Column(name = "alias", length = 32)
    private String alias;

    @Column(name = "country_icon", length = 64)
    private String countryIcon;

    @Column(name = "status", length = 8)
    private Integer status;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getAreaId() {
        return areaId;
    }

    public void setAreaId(String areaId) {
        this.areaId = areaId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getCountryIcon() {
        return countryIcon;
    }

    public void setCountryIcon(String countryIcon) {
        this.countryIcon = countryIcon;
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
