package com.valor.vod.user.model.database.ddo;

import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.*;


@Entity
@Table(name = "device_user_1st_consume_log")
public class DeviceUser1stConsumeLog extends AbstractLMI {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private long id;

    @Column(name = "account_id")
    private long accountId;

    @Column(name = "account_type", length = 8)
    private int accountType;

    @Column(name = "did", length = 128)
    private String did;

    @Column(name = "consume_time")
    private long consumeTime;

    @Column(name = "attach_no", length = 64)
    private String attachNo;//Mac绑定的卡号(code或账号卡卡号，个人充值时为空)

    @Column(name = "brand_id", length = 32)
    private String brandId;//产品系列,默认mfc

    @Column(name = "consume_type", length = 8)
    private int consumeType;//0-充值卡code，1-账号卡卡号(MFC)，2-个人充值(MFC)


    @Column(name = "vendor_id")
    private long vendorId;


    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getAccountId() {
        return accountId;
    }

    public void setAccountId(long accountId) {
        this.accountId = accountId;
    }

    public int getAccountType() {
        return accountType;
    }

    public void setAccountType(int accountType) {
        this.accountType = accountType;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public long getConsumeTime() {
        return consumeTime;
    }

    public void setConsumeTime(long consumeTime) {
        this.consumeTime = consumeTime;
    }

    public String getAttachNo() {
        return attachNo;
    }

    public void setAttachNo(String attachNo) {
        this.attachNo = attachNo;
    }

    public String getBrandId() {
        return brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public int getConsumeType() {
        return consumeType;
    }

    public void setConsumeType(int consumeType) {
        this.consumeType = consumeType;
    }

    public long getVendorId() {
        return vendorId;
    }

    public void setVendorId(long vendorId) {
        this.vendorId = vendorId;
    }
}
