package com.valor.vod.user.model.database.ddo;

import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.*;

/**
 * @ClassName: LoginCodeShowDdo
 * @Auther: admin
 * @Date: 1/3/2019
 * @Version 1.0
 * @Description:
 */

@Entity
@Table(name = "mfc_login_code_show", indexes = {@Index(name = "index_login_code", columnList = "account_id,account_type,status,login_key")
})
public class LoginCodeShowDdo extends AbstractLMI {

    private static final long serialVersionUID = -4870488625289858882L;


    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id",
        length = 64)
    private long id;

    @Column(name = "account_id",
        length = 64)
    private Long accountId;

    @Column(name = "account_type")
    private Integer accountType = 0;

    @Column(name = "did",
        length = 64
    )
    private String did;

    @Column(name = "code",
        length = 128
    )
    private String code;

    @Column(name = "login_key",
        length = 32
    )
    private String loginKey = "";

    @Column(name = "status")
    private Integer status = 0;


    @Column(name = "expired_time")
    private long expiredTime = 0;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public long getExpiredTime() {
        return expiredTime;
    }

    public void setExpiredTime(long expiredTime) {
        this.expiredTime = expiredTime;
    }


    public String getLoginKey() {
        return loginKey;
    }

    public void setLoginKey(String loginKey) {
        this.loginKey = loginKey;
    }

    @Override
    public String toString() {
        return "LoginCodeShowDdo{" +
            "id=" + id +
            ", accountId=" + accountId +
            ", accountType=" + accountType +
            ", did='" + did + '\'' +
            ", code='" + code + '\'' +
            ", loginKey='" + loginKey + '\'' +
            ", status=" + status +
            ", expiredTime=" + expiredTime +
            '}';
    }
}
