package com.valor.vod.user.model.database.ddo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.valor.vod.api.model.common.AbstractPrintable;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

/**
 * @author Tom Tang
 * @date 2023/1/31
 */
@Getter
@Setter
@SuperBuilder
public class UserBaseLog extends AbstractPrintable {

    @JsonProperty("account_id")
    private String accountId;

    /**
     * 0：mac登录
     * 1: email登录
     * 2：account_card登录
     * 3：手机号
     * 5：第三方登录
     */
    @JsonProperty("login_type")
    private Integer loginType;

    @JsonProperty("account_name")
    private String accountName;

    @JsonProperty("account_source")
    private String accountSource;

    @JsonProperty("action_time")
    private Long actionTime;

    @JsonProperty("session_id")
    private String sessionId;

    @JsonProperty("event_version")
    private String eventVersion;

    @JsonProperty("source_id")
    private String sourceId;

    @JsonProperty("vendor_id")
    private String vendorId;

    @JsonProperty("user_status")
    private Integer userStatus;

    @JsonProperty("is_expired")
    private Integer isExpired;

    @JsonProperty("valid_date")
    private String validDate;

    @JsonProperty("system_language")
    private String systemLanguage;

    @JsonProperty("app_name")
    private String appName;

    @JsonProperty("ver_code")
    private String verCode;

    @JsonProperty("vno_id")
    private String vnoId;

    @JsonProperty("package_name")
    private String packageName;

    @JsonProperty("mac")
    private String mac;

    @JsonProperty("terminal_type")
    private String terminalType;

    @JsonProperty("manufacturer")
    private String manufacturer;

    @JsonProperty("brand")
    private String brand;

    @JsonProperty("model")
    private String model;

    @JsonProperty("os")
    private String os;

    @JsonProperty("android_id")
    private String androidId;

    @JsonProperty("android_version")
    private String androidVersion;

    @JsonProperty("sdk")
    private String sdk;

    @JsonProperty("ip")
    private String ip;
}
