/*
 * Created by Gabriel Souza on 26/10/18 11:08
 * Copyright Valoroso Ltd. (c) 2018.  All rights reserved.
 */

package com.valor.vod.user.model.database.ddo;

import com.google.common.base.Objects;
import com.valor.vod.api.model.common.AbstractPrintable;

import java.util.Date;

/**
 * Created by Frank.Huang on 2017/2/7.
 */
public class UserDeviceLog extends AbstractPrintable {

    private Date actionTime = new Date();
    private String actionType = "login";
    private String loginType = "device";
    private String checksum = "";
    private Long uid = -1L;
    private String did = "";
    private String clientIp = "";
    private String macDetail = "";
    private long appVer = 0;
    private String vendorName = "";

    private String device = "";
    private String email = "";
    private String vendorId = "";
    private String plan = "";
    private Long bizDate = 0L;

    public String getMacDetail() {
        return macDetail;
    }

    public void setMacDetail(String macDetail) {
        this.macDetail = macDetail;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public Date getActionTime() {
        return actionTime;
    }

    public void setActionTime(Date actionTime) {
        this.actionTime = actionTime;
    }

    public String getChecksum() {
        return checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getActionType() {
        return actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getLoginType() {
        return loginType;
    }

    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    public long getAppVer() {
        return appVer;
    }

    public void setAppVer(long appVer) {
        this.appVer = appVer;
    }

    public String getVendorName() {
        return vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getDevice() {
        return device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getVendorId() {
        return vendorId;
    }

    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }

    public String getPlan() {
        return plan;
    }

    public void setPlan(String plan) {
        this.plan = plan;
    }

    public Long getBizDate() {
        return bizDate;
    }

    public void setBizDate(Long bizDate) {
        this.bizDate = bizDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UserDeviceLog that = (UserDeviceLog) o;

        return Objects.equal(this.checksum, that.checksum) &&
            Objects.equal(this.uid, that.uid);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(checksum, uid);
    }
}
