package com.valor.vod.user.model.database.ddo;

import com.valor.vod.api.model.user.EAccountType;
import com.valor.vod.api.model.user.EServiceType;
import com.valor.vod.api.model.user.ESystemType;
import com.valor.vod.api.model.user.EUserGroup;
import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.*;
import java.util.Date;

/**
 * File        : Description : Author      : Frank Created     : 2015/9/29
 */
@Entity
@Table(name = "vms_user")
public class UserInfoDdo extends AbstractLMI {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "uid")
    private Long uid;

    @Column(name = "did", length = 128, unique = true)
    private String did;

    @Column(name = "unique_id", length = 128)
    private String uniqueId = "";

    @Column(name = "props")
    private Long props = 0L;

    @Column(name = "region", length = 64)
    private String region;

    @Column(name = "client_region", length = 64)
    private String clientRegion;

    @Column(name = "status")
    private int status = 0;

    @Column(name = "system_type")
    @Enumerated(EnumType.ORDINAL)
    private ESystemType systemType = ESystemType.HOT;

    @Column(name = "user_group")
    @Enumerated(EnumType.STRING)
    private EUserGroup userGroup = EUserGroup.STANDARD;

    @Column(name = "name", length = 32)
    private String name;

    @Column(name = "phone", length = 20)
    private String phone;

    @Column(name = "email", length = 64)
    private String email;

    @Column(name = "address", length = 128)
    private String address;

    @Column(name = "appver", columnDefinition = "bigint default 0")
    private long appver;

    @Column(name = "batch_number", length = 128)
    private String batchNumber;

    //分配给运营商的id
    @Column(name = "vendor_id", columnDefinition = "bigint default 0")
    private long vendorId;

    @Column(name = "vendor_channel_id", length = 128)
    private String vendorChannelId;

    //激活时间
    @Column(name = "act_date")
    private Date actDate;

    //付费时间
    @Column(name = "pay_date")
    private Date payDate;

    @Column(name = "login_uid")
    private Long loginUid;

    @Column(name = "login_id", length = 64)
    private String loginId;

    @Column(name = "login_key", length = 64)
    private String loginKey;

    @Column(name = "biz_to_account", columnDefinition = "int default 0")
    private int bizToAccount = 0;

    @Column(name = "login_type", columnDefinition = "int default 0")
    private int loginType = EAccountType.DEVICE.getCode();

    @Column(name = "remark", length = 1024)
    private String remark = "";

    @Column(name = "reason", length = 1024)
    private String reason = "";

    @Column(name = "install_type", columnDefinition = "int(11) default 0")
    private int installType;

    @Column(name = "plan", columnDefinition = "int(11) default 0")
    private int plan = 0;

    @Column(name = "service_type", columnDefinition = "int default 0")
    private Integer serviceType = EServiceType.ST_FREE.getCode();

    public int getPlan() {
        return plan;
    }

    public void setPlan(int plan) {
        this.plan = plan;
    }

    public String getUniqueId() {
        return uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public Long getProps() {
        return props;
    }

    public void setProps(Long props) {
        this.props = props;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public EUserGroup getUserGroup() {
        return userGroup;
    }

    public void setUserGroup(EUserGroup userGroup) {
        this.userGroup = userGroup;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public long getAppver() {
        return appver;
    }

    public void setAppver(long appver) {
        this.appver = appver;
    }

    public String getBatchNumber() {
        return batchNumber;
    }

    public void setBatchNumber(String batchNumber) {
        this.batchNumber = batchNumber;
    }

    public Long getVendorId() {
        return vendorId;
    }

    public void setVendorId(long vendorId) {
        this.vendorId = vendorId;
    }

    //public void setVendorId(Long vendorId) {
    //    this.vendorId = vendorId;
    //}

    public String getVendorChannelId() {
        return vendorChannelId;
    }

    public void setVendorChannelId(String vendorChannelId) {
        this.vendorChannelId = vendorChannelId;
    }


    public Date getActDate() {
        return actDate;
    }

    public void setActDate(Date actDate) {
        this.actDate = actDate;
    }

    public Date getPayDate() {
        return payDate;
    }

    public void setPayDate(Date payDate) {
        this.payDate = payDate;
    }

    public String getClientRegion() {
        return clientRegion;
    }

    public void setClientRegion(String clientRegion) {
        this.clientRegion = clientRegion;
    }

    public Long getLoginUid() {
        return loginUid;
    }

    public void setLoginUid(Long loginUid) {
        this.loginUid = loginUid;
    }

    public String getLoginId() {
        return loginId;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public String getLoginKey() {
        return loginKey;
    }

    public void setLoginKey(String loginKey) {
        this.loginKey = loginKey;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getBizToAccount() {
        return bizToAccount;
    }

    public void setBizToAccount(int bizToAccount) {
        this.bizToAccount = bizToAccount;
    }

    public int getLoginType() {
        return loginType;
    }

    public void setLoginType(int loginType) {
        this.loginType = loginType;
    }

    public int getInstallType() {
        return installType;
    }

    public void setInstallType(int installType) {
        this.installType = installType;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Integer getServiceType() {
        return serviceType;
    }

    public void setServiceType(Integer serviceType) {
        this.serviceType = serviceType;
    }

    public ESystemType getSystemType() {
        return systemType;
    }

    public void setSystemType(ESystemType systemType) {
        this.systemType = systemType;
    }
}
