package com.valor.vod.user.model.database.ddo;

import com.valor.vod.user.model.database.ddo.common.AbstractUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Project     : volor Description : Author      : Frank Create Time : 2015/10/18 10:27
 */
@Entity
@Table(name = "vms_login_account")
public class UserLoginAccountDdo extends AbstractUID {
    @Id
    @Column(name = "login_type")
    private int loginType = ELoginType.UNKNOWN.ordinal();

    @Id
    @Column(name = "login_id")
    private String loginId = "";

    @Column(name = "login_key", length = 64)
    private String loginKey = "";

    @Column(name = "login_name", length = 128)
    private String loginName = "";

    @Column(name = "login_account_id")
    private long loginAccountId = 0L;

    @Column(name = "login_account_props")
    private long loginAccountProps = 0L;

    @Column(name = "login_biz_expire")
    private long loginBizExpire = 0L;

    @Column(name = "did", length = 64)
    private String did = "";

    @Column(name = "client_ip", length = 64)
    private String clientIp = "";

    @Column(name = "client_region", length = 16)
    private String clientRegion = "";

    public int getLoginType() {
        return loginType;
    }

    public void setLoginType(int loginType) {
        this.loginType = loginType;
    }

    public String getLoginId() {
        return loginId;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public String getLoginKey() {
        return loginKey;
    }

    public void setLoginKey(String loginKey) {
        this.loginKey = loginKey;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getClientRegion() {
        return clientRegion;
    }

    public void setClientRegion(String clientRegion) {
        this.clientRegion = clientRegion;
    }

    public String getLoginName() {
        return loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public long getLoginAccountId() {
        return loginAccountId;
    }

    public void setLoginAccountId(long loginAccountId) {
        this.loginAccountId = loginAccountId;
    }

    public long getLoginAccountProps() {
        return loginAccountProps;
    }

    public void setLoginAccountProps(long loginAccountProps) {
        this.loginAccountProps = loginAccountProps;
    }

    public long getLoginBizExpire() {
        return loginBizExpire;
    }

    public void setLoginBizExpire(long loginBizExpire) {
        this.loginBizExpire = loginBizExpire;
    }
}
