package com.valor.vod.user.model.database.ddo;

import com.valor.vod.user.model.database.ddo.common.AbstractUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2017/1/19.
 */
@Entity
@Table(name = "user_retry_log")
public class UserRetryLog extends AbstractUID {
    @Id
    @Column(name = "retry_period")
    private long retryPeriod;

    @Id
    @Column(name = "retry_type")
    private ERetryType retryType;

    @Column(name = "retry_id", length = 64)
    private String retryId = "";

    @Column(name = "retry_times")
    private int retryTimes = 0;

    @Column(name = "first_ts")
    private long firstTS = 0;

    @Column(name = "latest_ts")
    private long latestTs = 0;

    @Column(name = "client_ip", length = 64)
    private String clientIp = "";

    public ERetryType getRetryType() {
        return retryType;
    }

    public void setRetryType(ERetryType retryType) {
        this.retryType = retryType;
    }

    public String getRetryId() {
        return retryId;
    }

    public void setRetryId(String retryId) {
        this.retryId = retryId;
    }

    public int getRetryTimes() {
        return retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public long getFirstTS() {
        return firstTS;
    }

    public void setFirstTS(long firstTS) {
        this.firstTS = firstTS;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public long getLatestTs() {
        return latestTs;
    }

    public void setLatestTs(long latestTs) {
        this.latestTs = latestTs;
    }

    public long getRetryPeriod() {
        return retryPeriod;
    }

    public void setRetryPeriod(long retryPeriod) {
        this.retryPeriod = retryPeriod;
    }
}
