package com.valor.vod.user.model.database.ddo;

import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.*;

/**
 * @ClassName: VendorSTConfigDdo
 * @Auther: admin
 * @Date: 1/23/2019
 * @Version 1.0
 * @Description:
 */

@Entity
@Table(name = "vms_vendor_st_config", indexes = {@Index(name = "index_vendor_id_status", columnList = "vendor_id,status")})
public class VendorSTConfigDdo extends AbstractLMI {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private Integer id;


    @Column(name = "vendor_id", columnDefinition = "bigint default 0")
    private long vendorId;

    @Column(name = "model", length = 32)
    private String model;

    @Column(name = "status")
    private int status = 1; // status: 1 active; 0: disable

    @Column(name = "remark", length = 64)
    private String remark;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public long getVendorId() {
        return vendorId;
    }

    public void setVendorId(long vendorId) {
        this.vendorId = vendorId;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
