/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type;

import com.vladmihalcea.hibernate.type.array.BooleanArrayType;
import com.vladmihalcea.hibernate.type.array.DateArrayType;
import com.vladmihalcea.hibernate.type.array.DecimalArrayType;
import com.vladmihalcea.hibernate.type.array.DoubleArrayType;
import com.vladmihalcea.hibernate.type.array.EnumArrayType;
import com.vladmihalcea.hibernate.type.array.IntArrayType;
import com.vladmihalcea.hibernate.type.array.ListArrayType;
import com.vladmihalcea.hibernate.type.array.LocalDateArrayType;
import com.vladmihalcea.hibernate.type.array.LocalDateTimeArrayType;
import com.vladmihalcea.hibernate.type.array.LongArrayType;
import com.vladmihalcea.hibernate.type.array.StringArrayType;
import com.vladmihalcea.hibernate.type.array.TimestampArrayType;
import com.vladmihalcea.hibernate.type.array.UUIDArrayType;
import com.vladmihalcea.hibernate.type.basic.Iso8601MonthType;
import com.vladmihalcea.hibernate.type.basic.MonthDayDateType;
import com.vladmihalcea.hibernate.type.basic.MonthDayIntegerType;
import com.vladmihalcea.hibernate.type.basic.NullableCharacterType;
import com.vladmihalcea.hibernate.type.basic.PostgreSQLCITextType;
import com.vladmihalcea.hibernate.type.basic.PostgreSQLEnumType;
import com.vladmihalcea.hibernate.type.basic.PostgreSQLHStoreType;
import com.vladmihalcea.hibernate.type.basic.PostgreSQLInetType;
import com.vladmihalcea.hibernate.type.basic.YearMonthDateType;
import com.vladmihalcea.hibernate.type.basic.YearMonthEpochType;
import com.vladmihalcea.hibernate.type.basic.YearMonthIntegerType;
import com.vladmihalcea.hibernate.type.basic.YearMonthTimestampType;
import com.vladmihalcea.hibernate.type.interval.OracleIntervalDayToSecondType;
import com.vladmihalcea.hibernate.type.interval.PostgreSQLIntervalType;
import com.vladmihalcea.hibernate.type.interval.PostgreSQLPeriodType;
import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import com.vladmihalcea.hibernate.type.json.JsonBlobType;
import com.vladmihalcea.hibernate.type.json.JsonNodeStringType;
import com.vladmihalcea.hibernate.type.json.JsonStringType;
import com.vladmihalcea.hibernate.type.json.JsonType;
import com.vladmihalcea.hibernate.type.money.CurrencyUnitType;
import com.vladmihalcea.hibernate.type.money.MonetaryAmountType;
import com.vladmihalcea.hibernate.type.range.PostgreSQLRangeType;
import com.vladmihalcea.hibernate.type.range.guava.PostgreSQLGuavaRangeType;
import com.vladmihalcea.hibernate.type.search.PostgreSQLTSVectorType;
import com.vladmihalcea.hibernate.util.ReflectionUtils;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.PostgreSQL82Dialect;
import org.hibernate.dialect.SQLServer2005Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;

public class HibernateTypesContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        boolean enableJson;
        JdbcServices jdbcServices = (JdbcServices)serviceRegistry.getService(JdbcServices.class);
        Dialect dialect = jdbcServices.getDialect();
        boolean bl = enableJson = ReflectionUtils.getClassOrNull("com.fasterxml.jackson.databind.ObjectMapper") != null;
        if (dialect instanceof PostgreSQL82Dialect) {
            this.contributeType(typeContributions, (Object)BooleanArrayType.INSTANCE).contributeType(typeContributions, (Object)DateArrayType.INSTANCE).contributeType(typeContributions, (Object)DecimalArrayType.INSTANCE).contributeType(typeContributions, (Object)DoubleArrayType.INSTANCE).contributeType(typeContributions, (Object)EnumArrayType.INSTANCE).contributeType(typeContributions, (Object)IntArrayType.INSTANCE).contributeType(typeContributions, (Object)ListArrayType.INSTANCE).contributeType(typeContributions, (Object)LocalDateArrayType.INSTANCE).contributeType(typeContributions, (Object)LocalDateTimeArrayType.INSTANCE).contributeType(typeContributions, (Object)LongArrayType.INSTANCE).contributeType(typeContributions, (Object)StringArrayType.INSTANCE).contributeType(typeContributions, (Object)TimestampArrayType.INSTANCE).contributeType(typeContributions, (Object)UUIDArrayType.INSTANCE).contributeType(typeContributions, PostgreSQLIntervalType.INSTANCE).contributeType(typeContributions, PostgreSQLPeriodType.INSTANCE).contributeType(typeContributions, (Object)PostgreSQLTSVectorType.INSTANCE).contributeType(typeContributions, (Object)PostgreSQLEnumType.INSTANCE).contributeType(typeContributions, PostgreSQLHStoreType.INSTANCE).contributeType(typeContributions, PostgreSQLInetType.INSTANCE).contributeType(typeContributions, PostgreSQLRangeType.INSTANCE).contributeType(typeContributions, PostgreSQLCITextType.INSTANCE);
            if (ReflectionUtils.getClassOrNull("com.google.common.collect.Range") != null) {
                this.contributeType(typeContributions, PostgreSQLGuavaRangeType.INSTANCE);
            }
            if (enableJson) {
                this.contributeType(typeContributions, (Object)JsonBinaryType.INSTANCE);
            }
        } else if (dialect instanceof MySQLDialect) {
            if (enableJson) {
                this.contributeType(typeContributions, (Object)JsonStringType.INSTANCE).contributeType(typeContributions, (Object)JsonNodeStringType.INSTANCE);
            }
        } else if (dialect instanceof SQLServer2005Dialect) {
            if (enableJson) {
                this.contributeType(typeContributions, (Object)JsonStringType.INSTANCE);
            }
        } else if (dialect instanceof Oracle8iDialect) {
            this.contributeType(typeContributions, OracleIntervalDayToSecondType.INSTANCE);
            if (enableJson) {
                this.contributeType(typeContributions, (Object)JsonStringType.INSTANCE).contributeType(typeContributions, (Object)JsonBlobType.INSTANCE);
            }
        }
        this.contributeType(typeContributions, NullableCharacterType.INSTANCE).contributeType(typeContributions, (Object)Iso8601MonthType.INSTANCE).contributeType(typeContributions, (Object)MonthDayDateType.INSTANCE).contributeType(typeContributions, (Object)MonthDayIntegerType.INSTANCE).contributeType(typeContributions, (Object)YearMonthDateType.INSTANCE).contributeType(typeContributions, (Object)YearMonthEpochType.INSTANCE).contributeType(typeContributions, (Object)YearMonthIntegerType.INSTANCE).contributeType(typeContributions, (Object)YearMonthTimestampType.INSTANCE);
        if (enableJson) {
            this.contributeType(typeContributions, (Object)JsonType.INSTANCE);
        }
        if (ReflectionUtils.getClassOrNull("org.javamoney.moneta.Money") != null) {
            this.contributeType(typeContributions, (Object)CurrencyUnitType.INSTANCE).contributeType(typeContributions, MonetaryAmountType.INSTANCE);
        }
    }

    private HibernateTypesContributor contributeType(TypeContributions typeContributions, Object type) {
        if (type instanceof BasicType) {
            typeContributions.contributeType((BasicType)type);
        } else if (type instanceof UserType) {
            typeContributions.contributeType((UserType)type, new String[]{type.getClass().getSimpleName()});
        } else if (type instanceof CompositeUserType) {
            typeContributions.contributeType((CompositeUserType)type, new String[]{type.getClass().getSimpleName()});
        } else {
            throw new UnsupportedOperationException(String.format("The [%s] is not supported!", type.getClass()));
        }
        return this;
    }
}

