/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.json.internal;

import com.vladmihalcea.hibernate.type.json.internal.AbstractJsonSqlTypeDescriptor;
import com.vladmihalcea.hibernate.type.json.internal.JsonBinarySqlTypeDescriptor;
import com.vladmihalcea.hibernate.type.json.internal.JsonBlobSqlTypeDescriptor;
import com.vladmihalcea.hibernate.type.json.internal.JsonBytesSqlTypeDescriptor;
import com.vladmihalcea.hibernate.type.json.internal.JsonStringSqlTypeDescriptor;
import com.vladmihalcea.hibernate.type.util.ParameterTypeUtils;
import com.vladmihalcea.hibernate.util.StringUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.dialect.Database;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.ParameterizedType;

public class JsonSqlTypeDescriptor
extends AbstractJsonSqlTypeDescriptor
implements ParameterizedType {
    private volatile Dialect dialect;
    private volatile AbstractJsonSqlTypeDescriptor sqlTypeDescriptor;
    private volatile Properties properties;

    public JsonSqlTypeDescriptor() {
    }

    public JsonSqlTypeDescriptor(Properties properties) {
        this.properties = properties;
    }

    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                JsonSqlTypeDescriptor.this.sqlTypeDescriptor(st.getConnection()).getBinder(javaTypeDescriptor).bind(st, value, index, options);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                JsonSqlTypeDescriptor.this.sqlTypeDescriptor(st.getConnection()).getBinder(javaTypeDescriptor).bind(st, value, name, options);
            }
        };
    }

    @Override
    protected Object extractJson(ResultSet rs, String name) throws SQLException {
        return this.sqlTypeDescriptor(rs.getStatement().getConnection()).extractJson(rs, name);
    }

    @Override
    protected Object extractJson(CallableStatement statement, int index) throws SQLException {
        return this.sqlTypeDescriptor(statement.getConnection()).extractJson(statement, index);
    }

    @Override
    protected Object extractJson(CallableStatement statement, String name) throws SQLException {
        return this.sqlTypeDescriptor(statement.getConnection()).extractJson(statement, name);
    }

    private AbstractJsonSqlTypeDescriptor sqlTypeDescriptor(Connection connection) {
        if (this.sqlTypeDescriptor == null) {
            this.sqlTypeDescriptor = this.resolveSqlTypeDescriptor(connection);
        }
        return this.sqlTypeDescriptor;
    }

    private AbstractJsonSqlTypeDescriptor resolveSqlTypeDescriptor(Connection connection) {
        try {
            StandardDialectResolver dialectResolver = new StandardDialectResolver();
            DatabaseMetaDataDialectResolutionInfoAdapter metaDataInfo = new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData());
            this.dialect = dialectResolver.resolveDialect((DialectResolutionInfo)metaDataInfo);
            if (this.dialect instanceof PostgreSQL81Dialect) {
                return JsonBinarySqlTypeDescriptor.INSTANCE;
            }
            if (this.dialect instanceof H2Dialect) {
                return JsonBytesSqlTypeDescriptor.INSTANCE;
            }
            if (this.dialect instanceof Oracle8iDialect) {
                String columnType;
                DynamicParameterizedType.ParameterType parameterType;
                if (this.properties != null && (parameterType = ParameterTypeUtils.resolve(this.properties)) != null && !StringUtils.isBlank(columnType = ParameterTypeUtils.getColumnType(parameterType))) {
                    switch (columnType) {
                        case "json": {
                            return JsonBytesSqlTypeDescriptor.of(Database.ORACLE);
                        }
                        case "blob": 
                        case "clob": {
                            return JsonBlobSqlTypeDescriptor.INSTANCE;
                        }
                        case "varchar2": 
                        case "nvarchar2": {
                            return JsonStringSqlTypeDescriptor.INSTANCE;
                        }
                    }
                }
                if (metaDataInfo.getDatabaseMajorVersion() >= 21) {
                    return JsonBytesSqlTypeDescriptor.of(Database.ORACLE);
                }
            }
            return JsonStringSqlTypeDescriptor.INSTANCE;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getSqlType() {
        return this.sqlTypeDescriptor != null ? this.sqlTypeDescriptor.getSqlType() : super.getSqlType();
    }

    public void setParameterValues(Properties parameters) {
        if (this.properties == null) {
            this.properties = parameters;
        } else {
            this.properties.putAll((Map<?, ?>)parameters);
        }
    }
}

