package com.vladmihalcea.hibernate.query;

import com.vladmihalcea.hibernate.util.ReflectionUtils;
import jakarta.persistence.Query;

/**
 * The {@link SQLExtractor} allows you to extract the
 * underlying SQL query generated by a JPQL or JPA Criteria API query.
 * <p>
 * For more details about how to use it, check out <a href="https://vladmihalcea.com/get-sql-from-jpql-or-criteria/">this article</a> on <a href="https://vladmihalcea.com/">vladmihalcea.com</a>.
 *
 * @author Vlad Mihalcea
 * @since 2.9.11
 */
public class SQLExtractor {

    protected SQLExtractor() {
    }

    /**
     * Get the underlying SQL generated by the provided JPA query.
     *
     * @param query JPA query
     * @return the underlying SQL generated by the provided JPA query
     */
    public static String from(Query query) {
        return ReflectionUtils.invokeMethod(query, "getQueryString");
    }
}
