/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.json.internal;

import com.vladmihalcea.hibernate.type.json.internal.AbstractJsonJdbcTypeDescriptor;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.dialect.Database;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;

public class JsonBytesJdbcTypeDescriptor
extends AbstractJsonJdbcTypeDescriptor {
    public static final JsonBytesJdbcTypeDescriptor INSTANCE = new JsonBytesJdbcTypeDescriptor();
    private static final Map<Database, JsonBytesJdbcTypeDescriptor> INSTANCE_MAP = new HashMap<Database, JsonBytesJdbcTypeDescriptor>();
    public static final String CHARSET = "UTF8";
    private final int jdbcType;

    public static JsonBytesJdbcTypeDescriptor of(Database database) {
        return INSTANCE_MAP.get(database);
    }

    public JsonBytesJdbcTypeDescriptor() {
        this.jdbcType = -2;
    }

    public JsonBytesJdbcTypeDescriptor(int jdbcType) {
        this.jdbcType = jdbcType;
    }

    @Override
    public int getJdbcTypeCode() {
        return this.jdbcType;
    }

    public <X> ValueBinder<X> getBinder(final JavaType<X> JavaType2) {
        return new BasicBinder<X>(JavaType2, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setBytes(index, JsonBytesJdbcTypeDescriptor.this.toJsonBytes((String)JavaType2.unwrap(value, String.class, options)));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setBytes(name, JsonBytesJdbcTypeDescriptor.this.toJsonBytes((String)JavaType2.unwrap(value, String.class, options)));
            }
        };
    }

    @Override
    protected Object extractJson(ResultSet rs, int paramIndex) throws SQLException {
        return this.fromJsonBytes(rs.getBytes(paramIndex));
    }

    @Override
    protected Object extractJson(CallableStatement statement, int index) throws SQLException {
        return this.fromJsonBytes(statement.getBytes(index));
    }

    @Override
    protected Object extractJson(CallableStatement statement, String name) throws SQLException {
        return this.fromJsonBytes(statement.getBytes(name));
    }

    protected byte[] toJsonBytes(String jsonValue) {
        try {
            return jsonValue.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String fromJsonBytes(byte[] jsonBytes) {
        if (jsonBytes == null) {
            return null;
        }
        try {
            return new String(jsonBytes, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        INSTANCE_MAP.put(Database.H2, INSTANCE);
        INSTANCE_MAP.put(Database.ORACLE, new JsonBytesJdbcTypeDescriptor(2016));
    }
}

