/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.json.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.vladmihalcea.hibernate.type.json.internal.JacksonUtil;
import com.vladmihalcea.hibernate.type.util.ObjectMapperWrapper;
import java.io.Serializable;
import org.hibernate.SharedSessionContract;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;

public class JsonNodeJavaTypeDescriptor
extends AbstractClassJavaType<JsonNode> {
    public static final JsonNodeJavaTypeDescriptor INSTANCE = new JsonNodeJavaTypeDescriptor();
    private ObjectMapperWrapper objectMapperWrapper;

    public JsonNodeJavaTypeDescriptor() {
        this(ObjectMapperWrapper.INSTANCE);
    }

    public JsonNodeJavaTypeDescriptor(final ObjectMapperWrapper objectMapperWrapper) {
        super(JsonNode.class, (MutabilityPlan)new MutableMutabilityPlan<JsonNode>(){

            public Serializable disassemble(JsonNode value, SharedSessionContract session) {
                return JacksonUtil.toString(value);
            }

            public JsonNode assemble(Serializable cached, SharedSessionContract session) {
                return JacksonUtil.toJsonNode((String)((Object)cached));
            }

            protected JsonNode deepCopyNotNull(JsonNode value) {
                return objectMapperWrapper.clone(value);
            }
        });
        this.objectMapperWrapper = objectMapperWrapper;
    }

    public boolean areEqual(JsonNode one, JsonNode another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return this.objectMapperWrapper.toJsonNode(this.objectMapperWrapper.toString(one)).equals((Object)this.objectMapperWrapper.toJsonNode(this.objectMapperWrapper.toString(another)));
    }

    public String toString(JsonNode value) {
        return this.objectMapperWrapper.toString(value);
    }

    public JsonNode fromString(CharSequence string) {
        return this.objectMapperWrapper.toJsonNode((String)string);
    }

    public <X> X unwrap(JsonNode value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        if (JsonNode.class.isAssignableFrom(type)) {
            return (X)this.objectMapperWrapper.toJsonNode(this.toString(value));
        }
        throw this.unknownUnwrap(type);
    }

    public <X> JsonNode wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        return this.fromString(value.toString());
    }
}

