/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.spring.repository;

import com.vladmihalcea.spring.repository.BaseJpaRepository;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.Session;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.AbstractSharedSessionContract;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;

public class BaseJpaRepositoryImpl<T, ID>
extends SimpleJpaRepository<T, ID>
implements BaseJpaRepository<T, ID> {
    private final EntityManager entityManager;
    private final JpaEntityInformation entityInformation;

    public BaseJpaRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityInformation = entityInformation;
        this.entityManager = entityManager;
    }

    @Override
    public <S extends T> S persist(S entity) {
        this.entityManager.persist(entity);
        return entity;
    }

    @Override
    public <S extends T> S persistAndFlush(S entity) {
        this.persist(entity);
        this.entityManager.flush();
        return entity;
    }

    @Override
    public <S extends T> List<S> persistAll(Iterable<S> entities) {
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            result.add(this.persist(entity));
        }
        return result;
    }

    @Override
    public <S extends T> List<S> peristAllAndFlush(Iterable<S> entities) {
        return this.executeBatch(() -> {
            ArrayList result = new ArrayList();
            for (Object entity : entities) {
                result.add(this.persist(entity));
            }
            this.entityManager.flush();
            return result;
        });
    }

    @Override
    public <S extends T> S merge(S entity) {
        return (S)this.entityManager.merge(entity);
    }

    @Override
    public <S extends T> S mergeAndFlush(S entity) {
        S result = this.merge(entity);
        this.entityManager.flush();
        return result;
    }

    @Override
    public <S extends T> List<S> mergeAll(Iterable<S> entities) {
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            result.add(this.merge(entity));
        }
        return result;
    }

    @Override
    public <S extends T> List<S> mergeAllAndFlush(Iterable<S> entities) {
        return this.executeBatch(() -> {
            ArrayList result = new ArrayList();
            for (Object entity : entities) {
                result.add(this.merge(entity));
            }
            this.entityManager.flush();
            return result;
        });
    }

    @Override
    public <S extends T> S update(S entity) {
        this.session().update(entity);
        return entity;
    }

    @Override
    public <S extends T> S updateAndFlush(S entity) {
        this.update(entity);
        this.entityManager.flush();
        return entity;
    }

    @Override
    public <S extends T> List<S> updateAll(Iterable<S> entities) {
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            result.add(this.update(entity));
        }
        return result;
    }

    @Override
    public <S extends T> List<S> updateAllAndFlush(Iterable<S> entities) {
        return this.executeBatch(() -> {
            ArrayList result = new ArrayList();
            for (Object entity : entities) {
                result.add(this.update(entity));
            }
            this.entityManager.flush();
            return result;
        });
    }

    @Override
    public T lockById(ID id, LockModeType lockMode) {
        return (T)this.entityManager.find(this.entityInformation.getJavaType(), id, lockMode);
    }

    protected Integer getBatchSize(Session session) {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)session.getSessionFactory().unwrap(SessionFactoryImplementor.class);
        JdbcServices jdbcServices = (JdbcServices)sessionFactory.getServiceRegistry().getService(JdbcServices.class);
        if (!jdbcServices.getExtractedMetaDataSupport().supportsBatchUpdates()) {
            return Integer.MIN_VALUE;
        }
        return ((AbstractSharedSessionContract)session.unwrap(AbstractSharedSessionContract.class)).getConfiguredJdbcBatchSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> R executeBatch(Supplier<R> callback) {
        Session session = this.session();
        Integer jdbcBatchSize = this.getBatchSize(session);
        Integer originalSessionBatchSize = session.getJdbcBatchSize();
        try {
            if (jdbcBatchSize == null) {
                session.setJdbcBatchSize(Integer.valueOf(10));
            }
            R r = callback.get();
            return r;
        }
        finally {
            session.setJdbcBatchSize(originalSessionBatchSize);
        }
    }

    protected Session session() {
        return (Session)this.entityManager.unwrap(Session.class);
    }
}

