/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.circuitbreaker.sentinel;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.util.Assert;

public class SentinelCircuitBreaker
implements CircuitBreaker {
    private final String resourceName;
    private final EntryType entryType;
    private final List<DegradeRule> rules;

    public SentinelCircuitBreaker(String resourceName, EntryType entryType, List<DegradeRule> rules) {
        Assert.hasText(resourceName, "resourceName cannot be blank");
        Assert.notNull(rules, "rules should not be null");
        this.resourceName = resourceName;
        this.entryType = entryType;
        this.rules = Collections.unmodifiableList(rules);
        this.applyToSentinelRuleManager();
    }

    public SentinelCircuitBreaker(String resourceName, List<DegradeRule> rules) {
        this(resourceName, EntryType.OUT, rules);
    }

    public SentinelCircuitBreaker(String resourceName) {
        this(resourceName, EntryType.OUT, Collections.emptyList());
    }

    private void applyToSentinelRuleManager() {
        if (this.rules == null || this.rules.isEmpty()) {
            return;
        }
        HashSet<DegradeRule> ruleSet = new HashSet<DegradeRule>(DegradeRuleManager.getRules());
        for (DegradeRule rule : this.rules) {
            if (rule == null) continue;
            rule.setResource(this.resourceName);
            ruleSet.add(rule);
        }
        DegradeRuleManager.loadRules(new ArrayList<DegradeRule>(ruleSet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(Supplier<T> toRun, Function<Throwable, T> fallback) {
        Entry entry = null;
        try {
            entry = SphU.entry(this.resourceName, this.entryType);
            T t = toRun.get();
            return t;
        }
        catch (BlockException ex) {
            T t = fallback.apply(ex);
            return t;
        }
        catch (Exception ex) {
            Tracer.trace(ex);
            T t = fallback.apply(ex);
            return t;
        }
        finally {
            if (entry != null) {
                entry.exit();
            }
        }
    }
}

