/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic.limit;

import com.alibaba.csp.sentinel.cluster.flow.statistic.limit.RequestLimiter;
import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class GlobalRequestLimiter {
    private static final Map<String, RequestLimiter> GLOBAL_QPS_LIMITER_MAP = new ConcurrentHashMap<String, RequestLimiter>();

    public static void initIfAbsent(String namespace) {
        AssertUtil.notEmpty(namespace, "namespace cannot be empty");
        if (!GLOBAL_QPS_LIMITER_MAP.containsKey(namespace)) {
            GLOBAL_QPS_LIMITER_MAP.put(namespace, new RequestLimiter(ClusterServerConfigManager.getMaxAllowedQps(namespace)));
        }
    }

    public static RequestLimiter getRequestLimiter(String namespace) {
        if (namespace == null) {
            return null;
        }
        return GLOBAL_QPS_LIMITER_MAP.get(namespace);
    }

    public static boolean tryPass(String namespace) {
        if (namespace == null) {
            return false;
        }
        RequestLimiter limiter = GLOBAL_QPS_LIMITER_MAP.get(namespace);
        if (limiter == null) {
            return true;
        }
        return limiter.tryPass();
    }

    public static double getCurrentQps(String namespace) {
        RequestLimiter limiter = GlobalRequestLimiter.getRequestLimiter(namespace);
        if (limiter == null) {
            return 0.0;
        }
        return limiter.getQps();
    }

    public static double getMaxAllowedQps(String namespace) {
        RequestLimiter limiter = GlobalRequestLimiter.getRequestLimiter(namespace);
        if (limiter == null) {
            return 0.0;
        }
        return limiter.getQpsAllowed();
    }

    public static void applyMaxQpsChange(double maxAllowedQps) {
        AssertUtil.isTrue(maxAllowedQps >= 0.0, "max allowed QPS should > 0");
        for (RequestLimiter limiter : GLOBAL_QPS_LIMITER_MAP.values()) {
            if (limiter == null) continue;
            limiter.setQpsAllowed(maxAllowedQps);
        }
    }

    private GlobalRequestLimiter() {
    }
}

