/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.codec;

import com.alibaba.csp.sentinel.cluster.codec.EntityDecoder;
import com.alibaba.csp.sentinel.cluster.codec.request.RequestEntityDecoder;
import com.alibaba.csp.sentinel.cluster.request.ClusterRequest;
import com.alibaba.csp.sentinel.cluster.server.codec.registry.RequestDataDecodeRegistry;
import com.alibaba.csp.sentinel.log.RecordLog;
import io.netty.buffer.ByteBuf;

public class DefaultRequestEntityDecoder
implements RequestEntityDecoder<ByteBuf, ClusterRequest> {
    @Override
    public ClusterRequest decode(ByteBuf source2) {
        if (source2.readableBytes() >= 5) {
            int xid = source2.readInt();
            byte type = source2.readByte();
            EntityDecoder<ByteBuf, Object> dataDecoder = RequestDataDecodeRegistry.getDecoder(type);
            if (dataDecoder == null) {
                RecordLog.warn("Unknown type of request data decoder: {}", type);
                return null;
            }
            Object data = source2.readableBytes() == 0 ? null : dataDecoder.decode(source2);
            return new ClusterRequest<Object>(xid, type, data);
        }
        return null;
    }
}

