/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.eagleeye;

import com.alibaba.csp.sentinel.eagleeye.StatEntryFunc;
import com.alibaba.csp.sentinel.eagleeye.StatEntryFuncFactory;
import com.alibaba.csp.sentinel.eagleeye.StatLogger;
import java.util.Arrays;
import java.util.List;

public final class StatEntry {
    private final StatLogger statLogger;
    private final String[] keys;
    private transient int hash;

    public StatEntry(StatLogger statLogger, String key) {
        this.statLogger = statLogger;
        this.keys = new String[]{key};
    }

    public StatEntry(StatLogger statLogger, String key1, String key2) {
        this.statLogger = statLogger;
        this.keys = new String[]{key1, key2};
    }

    public StatEntry(StatLogger statLogger, String key1, String key2, String key3) {
        this.statLogger = statLogger;
        this.keys = new String[]{key1, key2, key3};
    }

    public StatEntry(StatLogger statLogger, String key1, String key2, String key3, String key4) {
        this.statLogger = statLogger;
        this.keys = new String[]{key1, key2, key3, key4};
    }

    public StatEntry(StatLogger statLogger, String key1, String key2, String key3, String key4, String key5) {
        this.statLogger = statLogger;
        this.keys = new String[]{key1, key2, key3, key4, key5};
    }

    public StatEntry(StatLogger statLogger, String key1, String key2, String key3, String key4, String key5, String key6) {
        this.statLogger = statLogger;
        this.keys = new String[]{key1, key2, key3, key4, key5, key6};
    }

    public StatEntry(StatLogger statLogger, String key1, String key2, String key3, String key4, String key5, String key6, String key7) {
        this.statLogger = statLogger;
        this.keys = new String[]{key1, key2, key3, key4, key5, key6, key7};
    }

    public StatEntry(StatLogger statLogger, String key1, String key2, String key3, String key4, String key5, String key6, String key7, String key8) {
        this.statLogger = statLogger;
        this.keys = new String[]{key1, key2, key3, key4, key5, key6, key7, key8};
    }

    public StatEntry(StatLogger statLogger, String key1, String ... moreKeys) {
        String[] keys2 = new String[1 + moreKeys.length];
        keys2[0] = key1;
        for (int i2 = 0; i2 < moreKeys.length; ++i2) {
            keys2[i2 + 1] = moreKeys[i2];
        }
        this.statLogger = statLogger;
        this.keys = keys2;
    }

    public StatEntry(StatLogger statLogger, List<String> keys2) {
        if (keys2 == null || keys2.isEmpty()) {
            throw new IllegalArgumentException("keys empty or null: " + keys2);
        }
        this.statLogger = statLogger;
        this.keys = keys2.toArray(new String[keys2.size()]);
    }

    public StatEntry(StatLogger statLogger, String[] keys2) {
        if (keys2 == null || keys2.length == 0) {
            throw new IllegalArgumentException("keys empty or null");
        }
        this.statLogger = statLogger;
        this.keys = Arrays.copyOf(keys2, keys2.length);
    }

    public String[] getKeys() {
        return this.keys;
    }

    void appendTo(StringBuilder appender, char delimiter) {
        int len = this.keys.length;
        if (len > 0) {
            appender.append(this.keys[0]);
            for (int i2 = 1; i2 < len; ++i2) {
                appender.append(delimiter).append(this.keys[i2]);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("StatKeys [");
        this.appendTo(sb, ',');
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        if (this.hash == 0) {
            int result = 1;
            this.hash = result = 31 * result + Arrays.hashCode(this.keys);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatEntry other = (StatEntry)obj;
        if (this.hash != 0 && other.hash != 0 && this.hash != other.hash) {
            return false;
        }
        return Arrays.equals(this.keys, other.keys);
    }

    StatEntryFunc getFunc(StatEntryFuncFactory factory2) {
        return this.statLogger.getRollingData().getStatEntryFunc(this, factory2);
    }

    public void count() {
        this.count(1L);
    }

    public void count(long count) {
        this.getFunc(StatEntryFuncFactory.COUNT_SUM).count(count);
    }

    public void countAndSum(long valueToSum) {
        this.countAndSum(1L, valueToSum);
    }

    public void countAndSum(long count, long valueToSum) {
        this.getFunc(StatEntryFuncFactory.COUNT_SUM).countAndSum(count, valueToSum);
    }

    public void minMax(long candidate) {
        this.minMax(candidate, null);
    }

    public void minMax(long candidate, String ref) {
        this.getFunc(StatEntryFuncFactory.MIN_MAX).minMax(candidate, ref);
    }
}

