/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.heartbeat;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.transport.HeartbeatSender;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import com.alibaba.csp.sentinel.transport.endpoint.Endpoint;
import com.alibaba.csp.sentinel.transport.heartbeat.HeartbeatMessage;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpClient;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpRequest;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpResponse;
import java.util.List;

public class SimpleHttpHeartbeatSender
implements HeartbeatSender {
    private static final int OK_STATUS = 200;
    private static final long DEFAULT_INTERVAL = 10000L;
    private final HeartbeatMessage heartBeat = new HeartbeatMessage();
    private final SimpleHttpClient httpClient = new SimpleHttpClient();
    private final List<Endpoint> addressList;
    private int currentAddressIdx = 0;

    public SimpleHttpHeartbeatSender() {
        List<Endpoint> newAddrs = TransportConfig.getConsoleServerList();
        if (newAddrs.isEmpty()) {
            RecordLog.warn("[SimpleHttpHeartbeatSender] Dashboard server address not configured or not available", new Object[0]);
        } else {
            RecordLog.info("[SimpleHttpHeartbeatSender] Default console address list retrieved: {}", newAddrs);
        }
        this.addressList = newAddrs;
    }

    @Override
    public boolean sendHeartbeat() throws Exception {
        if (TransportConfig.getRuntimePort() <= 0) {
            RecordLog.info("[SimpleHttpHeartbeatSender] Command server port not initialized, won't send heartbeat", new Object[0]);
            return false;
        }
        Endpoint addrInfo = this.getAvailableAddress();
        if (addrInfo == null) {
            return false;
        }
        SimpleHttpRequest request = new SimpleHttpRequest(addrInfo, TransportConfig.getHeartbeatApiPath());
        request.setParams(this.heartBeat.generateCurrentMessage());
        try {
            SimpleHttpResponse response = this.httpClient.post(request);
            if (response.getStatusCode() == 200) {
                return true;
            }
            if (this.clientErrorCode(response.getStatusCode()) || this.serverErrorCode(response.getStatusCode())) {
                RecordLog.warn("[SimpleHttpHeartbeatSender] Failed to send heartbeat to " + addrInfo + ", http status code: " + response.getStatusCode(), new Object[0]);
            }
        }
        catch (Exception e) {
            RecordLog.warn("[SimpleHttpHeartbeatSender] Failed to send heartbeat to " + addrInfo, e);
        }
        return false;
    }

    @Override
    public long intervalMs() {
        return 10000L;
    }

    private Endpoint getAvailableAddress() {
        if (this.addressList == null || this.addressList.isEmpty()) {
            return null;
        }
        if (this.currentAddressIdx < 0) {
            this.currentAddressIdx = 0;
        }
        int index = this.currentAddressIdx % this.addressList.size();
        return this.addressList.get(index);
    }

    private boolean clientErrorCode(int code) {
        return code > 399 && code < 500;
    }

    private boolean serverErrorCode(int code) {
        return code > 499 && code < 600;
    }
}

