/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.task.engine;

import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.common.task.engine.NacosTaskExecuteEngine;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNacosTaskExecuteEngine<T extends NacosTask>
implements NacosTaskExecuteEngine<T> {
    private final Logger log;
    private final ConcurrentHashMap<Object, NacosTaskProcessor> taskProcessors = new ConcurrentHashMap();
    private NacosTaskProcessor defaultTaskProcessor;

    public AbstractNacosTaskExecuteEngine(Logger logger2) {
        this.log = null != logger2 ? logger2 : LoggerFactory.getLogger(AbstractNacosTaskExecuteEngine.class.getName());
    }

    @Override
    public void addProcessor(Object key, NacosTaskProcessor taskProcessor) {
        this.taskProcessors.putIfAbsent(key, taskProcessor);
    }

    @Override
    public void removeProcessor(Object key) {
        this.taskProcessors.remove(key);
    }

    @Override
    public NacosTaskProcessor getProcessor(Object key) {
        return this.taskProcessors.containsKey(key) ? this.taskProcessors.get(key) : this.defaultTaskProcessor;
    }

    @Override
    public Collection<Object> getAllProcessorKey() {
        return this.taskProcessors.keySet();
    }

    @Override
    public void setDefaultTaskProcessor(NacosTaskProcessor defaultTaskProcessor) {
        this.defaultTaskProcessor = defaultTaskProcessor;
    }

    protected Logger getEngineLog() {
        return this.log;
    }
}

