/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.transformlet.impl;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.TtlRunnable;
import com.alibaba.ttl.spi.TtlAttachments;
import com.alibaba.ttl.spi.TtlEnhanced;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtBehavior;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtNewMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Modifier;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class);

    @NonNull
    static String signatureOfMethod(@NonNull CtBehavior method) throws NotFoundException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Modifier.toString(method.getModifiers()));
        if (method instanceof CtMethod) {
            String returnType = ((CtMethod)method).getReturnType().getSimpleName();
            stringBuilder.append(" ").append(returnType);
        }
        stringBuilder.append(" ").append(method.getName()).append("(");
        CtClass[] parameterTypes = method.getParameterTypes();
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            CtClass parameterType = parameterTypes[i2];
            if (i2 != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(parameterType.getSimpleName());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @NonNull
    static String renamedMethodNameByTtl(@NonNull CtMethod method) {
        return "original$" + method.getName() + "$method$renamed$by$ttl";
    }

    static void doTryFinallyForMethod(@NonNull CtMethod method, @NonNull String beforeCode, @NonNull String finallyCode) throws CannotCompileException, NotFoundException {
        Utils.doTryFinallyForMethod(method, Utils.renamedMethodNameByTtl(method), beforeCode, finallyCode);
    }

    static void doTryFinallyForMethod(@NonNull CtMethod method, @NonNull String renamedMethodName, @NonNull String beforeCode, @NonNull String finallyCode) throws CannotCompileException, NotFoundException {
        CtClass clazz = method.getDeclaringClass();
        CtMethod newMethod = CtNewMethod.copy(method, clazz, null);
        method.setName(renamedMethodName);
        method.setModifiers(method.getModifiers() & 0xFFFFFFFE & 0xFFFFFFFB | 2);
        String returnOp = method.getReturnType() == CtClass.voidType ? "" : "return ";
        String code = "{\n" + beforeCode + "\ntry {\n    " + returnOp + renamedMethodName + "($$);\n} finally {\n    " + finallyCode + "\n} }";
        newMethod.setBody(code);
        clazz.addMethod(newMethod);
        logger.info("insert code around method " + Utils.signatureOfMethod(newMethod) + " of class " + clazz.getName() + ": " + code);
    }

    @Nullable
    public static Object doCaptureWhenNotTtlEnhanced(@Nullable Object obj) {
        if (obj instanceof TtlEnhanced) {
            return null;
        }
        return TransmittableThreadLocal.Transmitter.capture();
    }

    public static void setAutoWrapperAttachment(@Nullable Object ttlAttachment) {
        if (Utils.notTtlAttachments(ttlAttachment)) {
            return;
        }
        ((TtlAttachments)ttlAttachment).setTtlAttachment("ttl.is.auto.wrapper", true);
    }

    @Nullable
    public static Runnable unwrapIfIsAutoWrapper(@Nullable Runnable runnable2) {
        if (Utils.isAutoWrapper(runnable2)) {
            return TtlRunnable.unwrap(runnable2);
        }
        return runnable2;
    }

    private static boolean notTtlAttachments(@Nullable Object ttlAttachment) {
        return !(ttlAttachment instanceof TtlAttachments);
    }

    private static boolean isAutoWrapper(@Nullable Runnable ttlAttachments) {
        if (Utils.notTtlAttachments(ttlAttachments)) {
            return false;
        }
        Boolean value = (Boolean)((TtlAttachments)((Object)ttlAttachments)).getTtlAttachment("ttl.is.auto.wrapper");
        if (value == null) {
            return false;
        }
        return value;
    }
}

