/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor.util;

import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.Sequence;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

public final class Util {
    private static final Unsafe THE_UNSAFE;

    public static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public static long getMinimumSequence(Sequence[] sequences) {
        return Util.getMinimumSequence(sequences, Long.MAX_VALUE);
    }

    public static long getMinimumSequence(Sequence[] sequences, long minimum) {
        int n = sequences.length;
        for (int i2 = 0; i2 < n; ++i2) {
            long value = sequences[i2].get();
            minimum = Math.min(minimum, value);
        }
        return minimum;
    }

    public static Sequence[] getSequencesFor(EventProcessor ... processors) {
        Sequence[] sequences = new Sequence[processors.length];
        for (int i2 = 0; i2 < sequences.length; ++i2) {
            sequences[i2] = processors[i2].getSequence();
        }
        return sequences;
    }

    public static Unsafe getUnsafe() {
        return THE_UNSAFE;
    }

    public static int log2(int i2) {
        int r = 0;
        while ((i2 >>= 1) != 0) {
            ++r;
        }
        return r;
    }

    static {
        try {
            PrivilegedExceptionAction<Unsafe> action = new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                    theUnsafe.setAccessible(true);
                    return (Unsafe)theUnsafe.get(null);
                }
            };
            THE_UNSAFE = AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load unsafe", e);
        }
    }
}

