/*
 * Decompiled with CFR 0.152.
 */
package com.volar.systemdev.sentinel.alarm;

import com.volar.systemdev.sentinel.alarm.SentinelAlarmEntity;
import common.config.tools.config.ConfigTools3;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SentinelAlarmService {
    private static Logger log = LoggerFactory.getLogger(SentinelAlarmService.class);
    @Autowired
    private RestTemplate sentinalRestTemplate;
    private ExecutorService sentThreadPool = Executors.newFixedThreadPool(ConfigTools3.getInt("vod.sentinal.alarm.threadCount", 1));
    Map<String, Long> infoTimes = new ConcurrentHashMap<String, Long>();

    public void alarm(String key, String info) {
        boolean enabled = ConfigTools3.getBoolean("vod.sentinal.alarm.enabled", true);
        if (!enabled) {
            log.info("alarm(),sentinel alarm is disabled.");
            return;
        }
        this.sentThreadPool.execute(() -> {
            try {
                SentinelAlarmService sentinelAlarmService = this;
                synchronized (sentinelAlarmService) {
                    int infoTimeSize = ConfigTools3.getInt("vod.sentinal.alarm.infoTimeSize", 100000);
                    if (this.infoTimes.size() > infoTimeSize) {
                        log.info("alarm(),infoTimes size is exceeded max.{} > {}", (Object)this.infoTimes.size(), (Object)infoTimeSize);
                        this.infoTimes.clear();
                    }
                    int alarmPeriodMs = ConfigTools3.getInt("vod.sentinal.alarm.alarmPeriodMs", 30000);
                    Long lastTime = this.infoTimes.getOrDefault(key, null);
                    if (lastTime != null && System.currentTimeMillis() - lastTime < (long)alarmPeriodMs) {
                        log.info("alarm(),sentinel alarm is ignore in {}ms.{}", (Object)alarmPeriodMs, (Object)key);
                        return;
                    }
                    this.infoTimes.put(key, System.currentTimeMillis());
                }
                this.doAlarm(key, info);
            }
            catch (Exception ex) {
                log.error("alarm(),exception.", ex);
            }
        });
    }

    private void doAlarm(String key, String info) throws Exception {
        HttpHeaders requestHeaders = new HttpHeaders();
        MediaType mediaType = MediaType.parseMediaType("application/json;charset=utf-8");
        requestHeaders.setContentType(mediaType);
        String larkUrl = ConfigTools3.getString("vod.sentinal.alarm.larkUrl", "");
        SentinelAlarmEntity alarmEntity = new SentinelAlarmEntity();
        alarmEntity.setUrl(larkUrl);
        alarmEntity.setMsg_type("text");
        alarmEntity.setContent(new SentinelAlarmEntity.SentinelAlarmContentEntity(info));
        HttpEntity<SentinelAlarmEntity> httpEntity = new HttpEntity<SentinelAlarmEntity>(alarmEntity, requestHeaders);
        String url = ConfigTools3.getString("vod.sentinal.alarm.noticeUrl", "");
        log.info("doAlarm(),noticeUrl:{},lackUrl:{},message:[{}]", url, larkUrl, key);
        ResponseEntity<String> postForEntity = null;
        postForEntity = this.sentinalRestTemplate.postForEntity(url, httpEntity, String.class, new Object[0]);
        if (postForEntity == null) {
            log.error("doAlarm(),alarm response is empty");
            throw new Exception("alarm response is empty");
        }
        log.info("doAlarm(),response:{},{}", (Object)postForEntity.getStatusCode(), postForEntity.getBody());
    }
}

