/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.aes;

import common.config.tools.aes.Base64Tools;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESTools {
    private static final Logger logger = LoggerFactory.getLogger(AESTools.class);
    private static final String KEY_ALGORITHM = "AES";
    private static final int KEY_LNE = 128;

    public static Key codeToKey(String key) throws Exception {
        byte[] keyBytes = Base64Tools.decodeAsByteArray(key);
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
        return secretKey;
    }

    public static String decrypt(byte[] data, byte[] key) throws Exception {
        SecretKeySpec k = new SecretKeySpec(key, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, k);
        return new String(cipher.doFinal(data), "UTF-8");
    }

    public static String decrypt(String data, String key) throws Exception {
        return AESTools.decrypt(Base64Tools.decodeAsByteArray(data), Base64Tools.decodeAsByteArray(key));
    }

    public static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        SecretKeySpec k = new SecretKeySpec(key, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, k);
        return cipher.doFinal(data);
    }

    public static String encrypt(String data, String key) throws Exception {
        byte[] dataBytes = data.getBytes("UTF-8");
        byte[] keyBytes = Base64Tools.decodeAsByteArray(key);
        return Base64Tools.encodeURLSafe(AESTools.encrypt(dataBytes, keyBytes));
    }
}

