/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.config;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import common.config.tools.aes.AESTools;
import common.config.tools.config.ConfigTools3;
import java.util.List;

public class ConfigAESTools
extends ConfigTools3 {
    public static String getAESString(String key, String aeskey, String defaultValue) {
        String v = ConfigAESTools.getAESString(key, aeskey);
        if (Strings.isNullOrEmpty(v)) {
            return defaultValue;
        }
        return v;
    }

    public static String getAESString(String key, String aeskey) {
        String original = ConfigAESTools.getString(key);
        if (Strings.isNullOrEmpty(original)) {
            return "";
        }
        try {
            return AESTools.decrypt(original, aeskey);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static List<String> getAESAsList(String key, String aeskey, String split) {
        String value = ConfigAESTools.getString(key, aeskey);
        if (Strings.isNullOrEmpty(value)) {
            return Lists.newArrayList();
        }
        return Splitter.on(split).omitEmptyStrings().splitToList(value);
    }

    public static List<String> getAESAsList(String key, String aeskey) {
        return ConfigAESTools.getAsList(key, ",");
    }
}

