/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.session.Session;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.RedirectBuilder;
import io.undertow.util.Sessions;
import java.io.IOException;

public class FormAuthenticationMechanism
implements AuthenticationMechanism {
    public static final String LOCATION_ATTRIBUTE = FormAuthenticationMechanism.class.getName() + ".LOCATION";
    public static final String DEFAULT_POST_LOCATION = "/j_security_check";
    private final String name;
    private final String loginPage;
    private final String errorPage;
    private final String postLocation;
    private final FormParserFactory formParserFactory;
    private final IdentityManager identityManager;

    public FormAuthenticationMechanism(String name, String loginPage, String errorPage) {
        this(FormParserFactory.builder().build(), name, loginPage, errorPage);
    }

    public FormAuthenticationMechanism(String name, String loginPage, String errorPage, String postLocation) {
        this(FormParserFactory.builder().build(), name, loginPage, errorPage, postLocation);
    }

    public FormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage) {
        this(formParserFactory, name, loginPage, errorPage, DEFAULT_POST_LOCATION);
    }

    public FormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, IdentityManager identityManager) {
        this(formParserFactory, name, loginPage, errorPage, DEFAULT_POST_LOCATION, identityManager);
    }

    public FormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, String postLocation) {
        this(formParserFactory, name, loginPage, errorPage, postLocation, null);
    }

    public FormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, String postLocation, IdentityManager identityManager) {
        this.name = name;
        this.loginPage = loginPage;
        this.errorPage = errorPage;
        this.postLocation = postLocation;
        this.formParserFactory = formParserFactory;
        this.identityManager = identityManager;
    }

    private IdentityManager getIdentityManager(SecurityContext securityContext) {
        return this.identityManager != null ? this.identityManager : securityContext.getIdentityManager();
    }

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange2, SecurityContext securityContext) {
        if (exchange2.getRequestPath().endsWith(this.postLocation) && exchange2.getRequestMethod().equals(Methods.POST)) {
            return this.runFormAuth(exchange2, securityContext);
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationMechanism.AuthenticationMechanismOutcome runFormAuth(HttpServerExchange exchange2, SecurityContext securityContext) {
        FormDataParser parser = this.formParserFactory.createParser(exchange2);
        if (parser == null) {
            UndertowLogger.SECURITY_LOGGER.debug("Could not authenticate as no form parser is present");
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        try {
            AuthenticationMechanism.AuthenticationMechanismOutcome outcome;
            block9: {
                FormData data = parser.parseBlocking();
                FormData.FormValue jUsername = data.getFirst("j_username");
                FormData.FormValue jPassword = data.getFirst("j_password");
                if (jUsername == null || jPassword == null) {
                    UndertowLogger.SECURITY_LOGGER.debugf("Could not authenticate as username or password was not present in the posted result for %s", (Object)exchange2);
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                }
                String userName = jUsername.getValue();
                String password = jPassword.getValue();
                outcome = null;
                PasswordCredential credential = new PasswordCredential(password.toCharArray());
                try {
                    IdentityManager identityManager = this.getIdentityManager(securityContext);
                    Account account = identityManager.verify(userName, credential);
                    if (account != null) {
                        securityContext.authenticationComplete(account, this.name, true);
                        UndertowLogger.SECURITY_LOGGER.debugf("Authenticated user %s using for auth for %s", (Object)account.getPrincipal().getName(), (Object)exchange2);
                        outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                    } else {
                        securityContext.authenticationFailed(UndertowMessages.MESSAGES.authenticationFailed(userName), this.name);
                    }
                    if (outcome != AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED) break block9;
                    this.handleRedirectBack(exchange2);
                    exchange2.endExchange();
                }
                catch (Throwable throwable) {
                    if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED) {
                        this.handleRedirectBack(exchange2);
                        exchange2.endExchange();
                    }
                    return outcome != null ? outcome : AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                }
            }
            return outcome != null ? outcome : AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void handleRedirectBack(HttpServerExchange exchange2) {
        String location;
        Session session = Sessions.getSession(exchange2);
        if (session != null && (location = (String)session.removeAttribute(LOCATION_ATTRIBUTE)) != null) {
            exchange2.addDefaultResponseListener(new DefaultResponseListener(){

                @Override
                public boolean handleDefaultResponse(HttpServerExchange exchange2) {
                    exchange2.getResponseHeaders().put(Headers.LOCATION, location);
                    exchange2.setStatusCode(302);
                    exchange2.endExchange();
                    return true;
                }
            });
        }
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange2, SecurityContext securityContext) {
        if (exchange2.getRelativePath().isEmpty()) {
            exchange2.getResponseHeaders().put(Headers.LOCATION, RedirectBuilder.redirect(exchange2, exchange2.getRelativePath() + "/", true));
            return new AuthenticationMechanism.ChallengeResult(true, 302);
        }
        if (exchange2.getRequestPath().endsWith(this.postLocation) && exchange2.getRequestMethod().equals(Methods.POST)) {
            UndertowLogger.SECURITY_LOGGER.debugf("Serving form auth error page %s for %s", (Object)this.loginPage, (Object)exchange2);
            Integer code = this.servePage(exchange2, this.errorPage);
            return new AuthenticationMechanism.ChallengeResult(true, code);
        }
        UndertowLogger.SECURITY_LOGGER.debugf("Serving login form %s for %s", (Object)this.loginPage, (Object)exchange2);
        this.storeInitialLocation(exchange2);
        Integer code = this.servePage(exchange2, this.loginPage);
        return new AuthenticationMechanism.ChallengeResult(true, code);
    }

    protected void storeInitialLocation(HttpServerExchange exchange2) {
        Session session = Sessions.getOrCreateSession(exchange2);
        session.setAttribute(LOCATION_ATTRIBUTE, RedirectBuilder.redirect(exchange2, exchange2.getRelativePath()));
    }

    protected Integer servePage(HttpServerExchange exchange2, String location) {
        FormAuthenticationMechanism.sendRedirect(exchange2, location);
        return 307;
    }

    static void sendRedirect(HttpServerExchange exchange2, String location) {
        String loc = exchange2.getRequestScheme() + "://" + exchange2.getHostAndPort() + location;
        exchange2.getResponseHeaders().put(Headers.LOCATION, loc);
    }
}

