/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class HttpTraceHandler
implements HttpHandler {
    private final HttpHandler handler;

    public HttpTraceHandler(HttpHandler handler) {
        this.handler = handler;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        if (exchange2.getRequestMethod().equals(Methods.TRACE)) {
            exchange2.getResponseHeaders().put(Headers.CONTENT_TYPE, "message/http");
            StringBuilder body2 = new StringBuilder("TRACE ");
            body2.append(exchange2.getRequestURI());
            if (!exchange2.getQueryString().isEmpty()) {
                body2.append('?');
                body2.append(exchange2.getQueryString());
            }
            body2.append(' ');
            body2.append(exchange2.getProtocol().toString());
            body2.append("\r\n");
            for (HeaderValues header : exchange2.getRequestHeaders()) {
                for (String value : header) {
                    body2.append(header.getHeaderName());
                    body2.append(": ");
                    body2.append(value);
                    body2.append("\r\n");
                }
            }
            body2.append("\r\n");
            exchange2.getResponseSender().send(body2.toString());
        } else {
            this.handler.handleRequest(exchange2);
        }
    }

    public String toString() {
        return "trace()";
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new HttpTraceHandler(handler);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "trace";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper();
        }
    }
}

