/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.cache;

import io.undertow.Handlers;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.cache.CachedHttpRequest;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.cache.ResponseCache;
import io.undertow.server.handlers.cache.ResponseCachingStreamSinkConduit;
import io.undertow.server.handlers.encoding.AllowedContentEncodings;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Headers;
import org.xnio.conduits.StreamSinkConduit;

public class CacheHandler
implements HttpHandler {
    private final DirectBufferCache cache;
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;

    public CacheHandler(DirectBufferCache cache, HttpHandler next) {
        this.cache = cache;
        this.next = next;
    }

    public CacheHandler(DirectBufferCache cache) {
        this.cache = cache;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        final ResponseCache responseCache = new ResponseCache(this.cache, exchange2);
        exchange2.putAttachment(ResponseCache.ATTACHMENT_KEY, responseCache);
        exchange2.addResponseWrapper(new ConduitWrapper<StreamSinkConduit>(){

            @Override
            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory2, HttpServerExchange exchange2) {
                if (!responseCache.isResponseCachable()) {
                    return factory2.create();
                }
                AllowedContentEncodings contentEncodings = exchange2.getAttachment(AllowedContentEncodings.ATTACHMENT_KEY);
                if (contentEncodings != null && !contentEncodings.isIdentity()) {
                    return factory2.create();
                }
                String lengthString = exchange2.getResponseHeaders().getFirst(Headers.CONTENT_LENGTH);
                if (lengthString == null) {
                    return factory2.create();
                }
                int length = Integer.parseInt(lengthString);
                CachedHttpRequest key = new CachedHttpRequest(exchange2);
                DirectBufferCache.CacheEntry entry = CacheHandler.this.cache.add(key, length);
                if (entry == null || entry.buffers().length == 0 || !entry.claimEnable()) {
                    return factory2.create();
                }
                if (!entry.reference()) {
                    entry.disable();
                    return factory2.create();
                }
                return new ResponseCachingStreamSinkConduit(factory2.create(), entry, length);
            }
        });
        this.next.handleRequest(exchange2);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public CacheHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }
}

