/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowMessages;
import io.undertow.io.IoCallback;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import java.io.IOException;
import java.nio.channels.Channel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.channels.StreamSinkChannel;

public class HttpContinue {
    private static final Set<HttpString> COMPATIBLE_PROTOCOLS;
    public static final String CONTINUE = "100-continue";
    private static final AttachmentKey<Boolean> ALREADY_SENT;

    public static boolean requiresContinueResponse(HttpServerExchange exchange2) {
        if (!COMPATIBLE_PROTOCOLS.contains(exchange2.getProtocol()) || exchange2.isResponseStarted() || !exchange2.getConnection().isContinueResponseSupported() || exchange2.getAttachment(ALREADY_SENT) != null) {
            return false;
        }
        HeaderMap requestHeaders = exchange2.getRequestHeaders();
        return HttpContinue.requiresContinueResponse(requestHeaders);
    }

    public static boolean requiresContinueResponse(HeaderMap requestHeaders) {
        HeaderValues expect = requestHeaders.get(Headers.EXPECT);
        if (expect != null) {
            for (String header : expect) {
                if (!header.equalsIgnoreCase(CONTINUE)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isContinueResponseSent(HttpServerExchange exchange2) {
        return exchange2.getAttachment(ALREADY_SENT) != null;
    }

    public static void sendContinueResponse(HttpServerExchange exchange2, IoCallback callback) {
        if (!exchange2.isResponseChannelAvailable()) {
            callback.onException(exchange2, null, UndertowMessages.MESSAGES.cannotSendContinueResponse());
            return;
        }
        HttpContinue.internalSendContinueResponse(exchange2, callback);
    }

    public static ContinueResponseSender createResponseSender(HttpServerExchange exchange2) throws IOException {
        if (!exchange2.isResponseChannelAvailable()) {
            throw UndertowMessages.MESSAGES.cannotSendContinueResponse();
        }
        if (exchange2.getAttachment(ALREADY_SENT) != null) {
            return new ContinueResponseSender(){

                @Override
                public boolean send() throws IOException {
                    return true;
                }

                @Override
                public void awaitWritable() throws IOException {
                }

                @Override
                public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
                }
            };
        }
        HttpServerExchange newExchange = exchange2.getConnection().sendOutOfBandResponse(exchange2);
        exchange2.putAttachment(ALREADY_SENT, true);
        newExchange.setStatusCode(100);
        newExchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, 0L);
        final StreamSinkChannel responseChannel = newExchange.getResponseChannel();
        return new ContinueResponseSender(){
            boolean shutdown = false;

            @Override
            public boolean send() throws IOException {
                if (!this.shutdown) {
                    this.shutdown = true;
                    responseChannel.shutdownWrites();
                }
                return responseChannel.flush();
            }

            @Override
            public void awaitWritable() throws IOException {
                responseChannel.awaitWritable();
            }

            @Override
            public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
                responseChannel.awaitWritable(time, timeUnit);
            }
        };
    }

    public static void markContinueResponseSent(HttpServerExchange exchange2) {
        exchange2.putAttachment(ALREADY_SENT, true);
    }

    public static void sendContinueResponseBlocking(HttpServerExchange exchange2) throws IOException {
        if (!exchange2.isResponseChannelAvailable()) {
            throw UndertowMessages.MESSAGES.cannotSendContinueResponse();
        }
        if (exchange2.getAttachment(ALREADY_SENT) != null) {
            return;
        }
        HttpServerExchange newExchange = exchange2.getConnection().sendOutOfBandResponse(exchange2);
        exchange2.putAttachment(ALREADY_SENT, true);
        newExchange.setStatusCode(100);
        newExchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, 0L);
        newExchange.startBlocking();
        newExchange.getOutputStream().close();
        newExchange.getInputStream().close();
    }

    public static void rejectExchange(HttpServerExchange exchange2) {
        exchange2.setStatusCode(417);
        exchange2.setPersistent(false);
        exchange2.endExchange();
    }

    private static void internalSendContinueResponse(final HttpServerExchange exchange2, final IoCallback callback) {
        if (exchange2.getAttachment(ALREADY_SENT) != null) {
            callback.onComplete(exchange2, null);
            return;
        }
        HttpServerExchange newExchange = exchange2.getConnection().sendOutOfBandResponse(exchange2);
        exchange2.putAttachment(ALREADY_SENT, true);
        newExchange.setStatusCode(100);
        newExchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, 0L);
        StreamSinkChannel responseChannel = newExchange.getResponseChannel();
        try {
            responseChannel.shutdownWrites();
            if (!responseChannel.flush()) {
                responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                    @Override
                    public void handleEvent(StreamSinkChannel channel) {
                        channel.suspendWrites();
                        exchange2.dispatch(new HttpHandler(){

                            @Override
                            public void handleRequest(HttpServerExchange exchange2) throws Exception {
                                callback.onComplete(exchange2, null);
                            }
                        });
                    }
                }, new ChannelExceptionHandler<Channel>(){

                    @Override
                    public void handleException(Channel channel, final IOException e) {
                        exchange2.dispatch(new HttpHandler(){

                            @Override
                            public void handleRequest(HttpServerExchange exchange2) throws Exception {
                                callback.onException(exchange2, null, e);
                            }
                        });
                    }
                }));
                responseChannel.resumeWrites();
                exchange2.dispatch();
            } else {
                callback.onComplete(exchange2, null);
            }
        }
        catch (IOException e) {
            callback.onException(exchange2, null, e);
        }
    }

    static {
        HashSet<HttpString> compat = new HashSet<HttpString>();
        compat.add(Protocols.HTTP_1_1);
        compat.add(Protocols.HTTP_2_0);
        COMPATIBLE_PROTOCOLS = Collections.unmodifiableSet(compat);
        ALREADY_SENT = AttachmentKey.create(Boolean.class);
    }

    public static interface ContinueResponseSender {
        public boolean send() throws IOException;

        public void awaitWritable() throws IOException;

        public void awaitWritable(long var1, TimeUnit var3) throws IOException;
    }
}

