/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.compat.rewrite;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.compat.rewrite.RewriteConfig;
import io.undertow.servlet.compat.rewrite.RewriteRule;
import io.undertow.servlet.compat.rewrite.UndertowResolver;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.util.Headers;
import io.undertow.util.QueryParameterUtils;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;

public class RewriteHandler
implements HttpHandler {
    private final RewriteConfig config;
    private final HttpHandler next;
    protected ThreadLocal<Boolean> invoked = new ThreadLocal();

    public RewriteHandler(RewriteConfig config, HttpHandler next) {
        this.config = config;
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        RewriteRule[] rules = this.config.getRules();
        if (rules == null || rules.length == 0) {
            this.next.handleRequest(exchange2);
            return;
        }
        if (Boolean.TRUE.equals(this.invoked.get())) {
            this.next.handleRequest(exchange2);
            this.invoked.set(null);
            return;
        }
        ServletRequestContext src = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequestImpl request = src.getOriginalRequest();
        HttpServletResponseImpl response = src.getOriginalResponse();
        UndertowResolver resolver = new UndertowResolver(src, src.getOriginalRequest());
        this.invoked.set(Boolean.TRUE);
        CharSequence url = exchange2.getRelativePath();
        CharSequence host = request.getServerName();
        boolean rewritten = false;
        boolean done = false;
        block0: for (int i2 = 0; i2 < rules.length; ++i2) {
            CharSequence test = rules[i2].isHost() ? host : url;
            CharSequence newtest = rules[i2].evaluate(test, resolver);
            if (newtest != null && !test.equals(newtest.toString())) {
                if (UndertowServletLogger.REQUEST_LOGGER.isDebugEnabled()) {
                    UndertowServletLogger.REQUEST_LOGGER.debug("Rewrote " + test + " as " + newtest + " with rule pattern " + rules[i2].getPatternString());
                }
                if (rules[i2].isHost()) {
                    host = newtest;
                } else {
                    url = newtest;
                }
                rewritten = true;
            }
            if (rules[i2].isForbidden() && newtest != null) {
                response.sendError(403);
                done = true;
                break;
            }
            if (rules[i2].isGone() && newtest != null) {
                response.sendError(410);
                done = true;
                break;
            }
            if (rules[i2].isRedirect() && newtest != null) {
                String queryString = request.getQueryString();
                StringBuffer urlString = new StringBuffer(url);
                if (queryString != null && queryString.length() > 0) {
                    int index = urlString.indexOf("?");
                    if (index != -1) {
                        if (rules[i2].isQsappend()) {
                            urlString.append('&');
                            urlString.append(queryString);
                        } else if (index == urlString.length() - 1) {
                            urlString.deleteCharAt(index);
                        }
                    } else {
                        urlString.append('?');
                        urlString.append(queryString);
                    }
                }
                if (urlString.charAt(0) == '/' && !RewriteHandler.hasScheme(urlString)) {
                    urlString.insert(0, request.getContextPath());
                }
                response.sendRedirect(urlString.toString());
                response.setStatus(rules[i2].getRedirectCode());
                done = true;
                break;
            }
            if (rules[i2].isCookie() && newtest != null) {
                Cookie cookie = new Cookie(rules[i2].getCookieName(), rules[i2].getCookieResult());
                cookie.setDomain(rules[i2].getCookieDomain());
                cookie.setMaxAge(rules[i2].getCookieLifetime());
                cookie.setPath(rules[i2].getCookiePath());
                cookie.setSecure(rules[i2].isCookieSecure());
                cookie.setHttpOnly(rules[i2].isCookieHttpOnly());
                response.addCookie(cookie);
            }
            if (rules[i2].isEnv() && newtest != null) {
                Map<String, String> attrs = exchange2.getAttachment(HttpServerExchange.REQUEST_ATTRIBUTES);
                if (attrs == null) {
                    attrs = new HashMap<String, String>();
                    exchange2.putAttachment(HttpServerExchange.REQUEST_ATTRIBUTES, attrs);
                }
                for (int j = 0; j < rules[i2].getEnvSize(); ++j) {
                    String envName = rules[i2].getEnvName(j);
                    String envResult = rules[i2].getEnvResult(j);
                    attrs.put(envName, envResult);
                    request.setAttribute(envName, envResult);
                }
            }
            if (rules[i2].isType() && newtest != null) {
                exchange2.getRequestHeaders().put(Headers.CONTENT_TYPE, rules[i2].getTypeValue());
            }
            if (rules[i2].isQsappend() && newtest != null) {
                String queryString = request.getQueryString();
                String urlString = url.toString();
                if (urlString.indexOf(63) != -1 && queryString != null) {
                    url = urlString + "&" + queryString;
                }
            }
            if (rules[i2].isChain() && newtest == null) {
                for (int j = i2; j < rules.length; ++j) {
                    if (rules[j].isChain()) continue;
                    i2 = j;
                    continue block0;
                }
                continue;
            }
            if (rules[i2].isLast() && newtest != null) break;
            if (rules[i2].isNext() && newtest != null) {
                i2 = 0;
                continue;
            }
            if (newtest == null) continue;
            i2 += rules[i2].getSkip();
        }
        if (rewritten) {
            if (!done) {
                String urlString = url.toString();
                String queryString = null;
                int queryIndex = urlString.indexOf(63);
                if (queryIndex != -1) {
                    queryString = urlString.substring(queryIndex + 1);
                    urlString = urlString.substring(0, queryIndex);
                }
                StringBuilder chunk = new StringBuilder();
                chunk.append(request.getContextPath());
                chunk.append(urlString);
                String requestPath = chunk.toString();
                exchange2.setRequestURI(requestPath);
                exchange2.setRequestPath(requestPath);
                exchange2.setRelativePath(urlString);
                if (queryString != null) {
                    exchange2.setQueryString(queryString);
                    exchange2.getQueryParameters().clear();
                    exchange2.getQueryParameters().putAll(QueryParameterUtils.parseQueryString(queryString, exchange2.getConnection().getUndertowOptions().get(UndertowOptions.URL_CHARSET, StandardCharsets.UTF_8.name())));
                }
                if (!host.equals(request.getServerName())) {
                    exchange2.getRequestHeaders().put(Headers.HOST, host + ":" + exchange2.getHostPort());
                }
                src.getDeployment().getHandler().handleRequest(exchange2);
            }
        } else {
            this.next.handleRequest(exchange2);
        }
        this.invoked.set(null);
    }

    protected static boolean hasScheme(StringBuffer uri) {
        int len = uri.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = uri.charAt(i2);
            if (c == ':') {
                return i2 > 0;
            }
            if (RewriteHandler.isSchemeChar(c)) continue;
            return false;
        }
        return false;
    }

    private static boolean isSchemeChar(char c) {
        return Character.isLetterOrDigit(c) || c == '+' || c == '-' || c == '.';
    }
}

