/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class MarkSecureHandler
implements HttpHandler {
    public static final HandlerWrapper WRAPPER = new Wrapper();
    private final HttpHandler next;

    public MarkSecureHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        exchange2.putAttachment(HttpServerExchange.SECURE_REQUEST, Boolean.TRUE);
        this.next.handleRequest(exchange2);
    }

    public String toString() {
        return "mark-secure()";
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "mark-secure";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return WRAPPER;
        }
    }

    public static class Wrapper
    implements HandlerWrapper {
        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new MarkSecureHandler(handler);
        }
    }
}

