/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.AuthorizationManager;
import io.undertow.servlet.api.SingleConstraintMatch;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletSecurityRoleHandler
implements HttpHandler {
    private final HttpHandler next;
    private final AuthorizationManager authorizationManager;

    public ServletSecurityRoleHandler(HttpHandler next, AuthorizationManager authorizationManager) {
        this.next = next;
        this.authorizationManager = authorizationManager;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        SecurityContext sc;
        List<SingleConstraintMatch> constraints;
        ServletRequestContext servletRequestContext = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletRequest request = servletRequestContext.getServletRequest();
        if (request.getDispatcherType() == DispatcherType.REQUEST && !this.authorizationManager.canAccessResource(constraints = servletRequestContext.getRequiredConstrains(), (sc = exchange2.getSecurityContext()).getAuthenticatedAccount(), servletRequestContext.getCurrentServlet().getManagedServlet().getServletInfo(), servletRequestContext.getOriginalRequest(), servletRequestContext.getDeployment())) {
            HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
            response.sendError(403);
            return;
        }
        this.next.handleRequest(exchange2);
    }
}

