/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.util;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.ImmediatePooledByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class SavedRequest
implements Serializable {
    private static final String SESSION_KEY = SavedRequest.class.getName();
    private final byte[] data;
    private final int dataLength;
    private final HttpString method;
    private final String requestPath;
    private final HashMap<HttpString, List<String>> headerMap = new HashMap();

    public SavedRequest(byte[] data, int dataLength, HttpString method, String requestPath, HeaderMap headerMap) {
        this.data = data;
        this.dataLength = dataLength;
        this.method = method;
        this.requestPath = requestPath;
        for (HeaderValues val : headerMap) {
            this.headerMap.put(val.getHeaderName(), new ArrayList<String>(val));
        }
    }

    public static int getMaxBufferSizeToSave(HttpServerExchange exchange2) {
        int maxSize = exchange2.getConnection().getUndertowOptions().get(UndertowOptions.MAX_BUFFERED_REQUEST_SIZE, 16384);
        return maxSize;
    }

    public static void trySaveRequest(HttpServerExchange exchange2) {
        int maxSize = SavedRequest.getMaxBufferSizeToSave(exchange2);
        if (maxSize > 0 && !exchange2.isRequestComplete()) {
            long requestContentLength = exchange2.getRequestContentLength();
            if (requestContentLength > (long)maxSize) {
                UndertowLogger.REQUEST_LOGGER.debugf("Request to %s was to large to save", (Object)exchange2.getRequestURI());
                return;
            }
            byte[] buffer = new byte[maxSize];
            int read = 0;
            int res = 0;
            InputStream in = exchange2.getInputStream();
            try {
                while ((res = in.read(buffer, read, buffer.length - read)) > 0) {
                    if ((read += res) != maxSize) continue;
                    UndertowLogger.REQUEST_LOGGER.debugf("Request to %s was to large to save", (Object)exchange2.getRequestURI());
                    return;
                }
                SavedRequest.trySaveRequest(exchange2, buffer, read);
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            }
        }
    }

    public static void trySaveRequest(HttpServerExchange exchange2, byte[] buffer, int length) {
        int maxSize = exchange2.getConnection().getUndertowOptions().get(UndertowOptions.MAX_BUFFERED_REQUEST_SIZE, 16384);
        if (maxSize > 0) {
            if (length > maxSize) {
                UndertowLogger.REQUEST_LOGGER.debugf("Request to %s was to large to save", (Object)exchange2.getRequestURI());
                return;
            }
            HeaderMap headers = new HeaderMap();
            for (HeaderValues entry : exchange2.getRequestHeaders()) {
                if (entry.getHeaderName().equals(Headers.CONTENT_LENGTH) || entry.getHeaderName().equals(Headers.TRANSFER_ENCODING) || entry.getHeaderName().equals(Headers.CONNECTION)) continue;
                headers.putAll(entry.getHeaderName(), entry);
            }
            SavedRequest request = new SavedRequest(buffer, length, exchange2.getRequestMethod(), exchange2.getRelativePath(), exchange2.getRequestHeaders());
            ServletRequestContext sc = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            HttpSessionImpl session = sc.getCurrentServletContext().getSession(exchange2, true);
            Session underlyingSession = System.getSecurityManager() == null ? session.getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(session));
            underlyingSession.setAttribute(SESSION_KEY, request);
        }
    }

    public static void tryRestoreRequest(HttpServerExchange exchange2, HttpSession session) {
        Session underlyingSession;
        SavedRequest request;
        if (session instanceof HttpSessionImpl && (request = (SavedRequest)(underlyingSession = System.getSecurityManager() == null ? ((HttpSessionImpl)session).getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(session))).getAttribute(SESSION_KEY)) != null && request.requestPath.equals(exchange2.getRelativePath()) && exchange2.isRequestComplete()) {
            UndertowLogger.REQUEST_LOGGER.debugf("restoring request body for request to %s", (Object)request.requestPath);
            exchange2.setRequestMethod(request.method);
            Connectors.ungetRequestBytes(exchange2, new ImmediatePooledByteBuffer(ByteBuffer.wrap(request.data, 0, request.dataLength)));
            underlyingSession.removeAttribute(SESSION_KEY);
            Iterator<HeaderValues> headerIterator = exchange2.getRequestHeaders().iterator();
            while (headerIterator.hasNext()) {
                HeaderValues header = headerIterator.next();
                if (header.getHeaderName().equals(Headers.CONNECTION)) continue;
                headerIterator.remove();
            }
            for (Map.Entry<HttpString, List<String>> header : request.headerMap.entrySet()) {
                exchange2.getRequestHeaders().putAll(header.getKey(), (Collection<String>)header.getValue());
            }
        }
    }
}

