/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.elasticsearch;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.elasticsearch.ReactiveElasticsearchRestClientProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.reactive.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.client.reactive.ReactiveRestClients;
import org.springframework.util.unit.DataSize;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ReactiveRestClients.class, WebClient.class, HttpClient.class})
@EnableConfigurationProperties(value={ReactiveElasticsearchRestClientProperties.class})
public class ReactiveElasticsearchRestClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ClientConfiguration clientConfiguration(ReactiveElasticsearchRestClientProperties properties) {
        ClientConfiguration.MaybeSecureClientConfigurationBuilder builder = ClientConfiguration.builder().connectedTo(properties.getEndpoints().toArray(new String[0]));
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties.isUseSsl()).whenTrue().toCall(() -> ((ClientConfiguration.MaybeSecureClientConfigurationBuilder)builder).usingSsl());
        map.from(properties.getUsername()).whenHasText().to(username -> builder.withBasicAuth(username, properties.getPassword()));
        map.from(properties.getConnectionTimeout()).to(arg_0 -> ((ClientConfiguration.MaybeSecureClientConfigurationBuilder)builder).withConnectTimeout(arg_0));
        map.from(properties.getSocketTimeout()).to(arg_0 -> ((ClientConfiguration.MaybeSecureClientConfigurationBuilder)builder).withSocketTimeout(arg_0));
        this.configureExchangeStrategies(map, (ClientConfiguration.TerminalClientConfigurationBuilder)builder, properties);
        return builder.build();
    }

    private void configureExchangeStrategies(PropertyMapper map, ClientConfiguration.TerminalClientConfigurationBuilder builder, ReactiveElasticsearchRestClientProperties properties) {
        map.from(properties.getMaxInMemorySize()).asInt(DataSize::toBytes).to(maxInMemorySize -> builder.withWebClientConfigurer(webClient -> {
            ExchangeStrategies exchangeStrategies = ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize((int)maxInMemorySize)).build();
            return webClient.mutate().exchangeStrategies(exchangeStrategies).build();
        }));
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveElasticsearchClient reactiveElasticsearchClient(ClientConfiguration clientConfiguration) {
        return ReactiveRestClients.create((ClientConfiguration)clientConfiguration);
    }
}

