/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.ClientHttpResponseStatusCodeException;
import org.springframework.cloud.client.loadbalancer.InterceptorRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRecoveryCallback;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRetryProperties;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class RetryLoadBalancerInterceptor
implements ClientHttpRequestInterceptor {
    private static final Log LOG = LogFactory.getLog(RetryLoadBalancerInterceptor.class);
    private final LoadBalancerClient loadBalancer;
    private final LoadBalancerRetryProperties lbProperties;
    private final LoadBalancerRequestFactory requestFactory;
    private final LoadBalancedRetryFactory lbRetryFactory;

    public RetryLoadBalancerInterceptor(LoadBalancerClient loadBalancer, LoadBalancerRetryProperties lbProperties, LoadBalancerRequestFactory requestFactory, LoadBalancedRetryFactory lbRetryFactory) {
        this.loadBalancer = loadBalancer;
        this.lbProperties = lbProperties;
        this.requestFactory = requestFactory;
        this.lbRetryFactory = lbRetryFactory;
    }

    @Override
    public ClientHttpResponse intercept(HttpRequest request, byte[] body2, ClientHttpRequestExecution execution) throws IOException {
        URI originalUri = request.getURI();
        String serviceName = originalUri.getHost();
        Assert.state(serviceName != null, "Request URI does not contain a valid hostname: " + originalUri);
        LoadBalancedRetryPolicy retryPolicy = this.lbRetryFactory.createRetryPolicy(serviceName, this.loadBalancer);
        RetryTemplate template = this.createRetryTemplate(serviceName, request, retryPolicy);
        return (ClientHttpResponse)template.execute(context -> {
            ServiceInstance serviceInstance = null;
            if (context instanceof LoadBalancedRetryContext) {
                LoadBalancedRetryContext lbContext = (LoadBalancedRetryContext)context;
                serviceInstance = lbContext.getServiceInstance();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Retrieved service instance from LoadBalancedRetryContext: %s", serviceInstance));
                }
            }
            if (serviceInstance == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Service instance retrieved from LoadBalancedRetryContext: was null. Reattempting service instance selection");
                }
                serviceInstance = this.loadBalancer.choose(serviceName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Selected service instance: %s", serviceInstance));
                }
            }
            ClientHttpResponse response = this.loadBalancer.execute(serviceName, serviceInstance, this.requestFactory.createRequest(request, body2, execution));
            int statusCode = response.getRawStatusCode();
            if (retryPolicy != null && retryPolicy.retryableStatusCode(statusCode)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Retrying on status code: %d", statusCode));
                }
                byte[] bodyCopy = StreamUtils.copyToByteArray(response.getBody());
                response.close();
                throw new ClientHttpResponseStatusCodeException(serviceName, response, bodyCopy);
            }
            return response;
        }, (RecoveryCallback)new LoadBalancedRecoveryCallback<ClientHttpResponse, ClientHttpResponse>(){

            @Override
            protected ClientHttpResponse createResponse(ClientHttpResponse response, URI uri) {
                return response;
            }
        });
    }

    private RetryTemplate createRetryTemplate(String serviceName, HttpRequest request, LoadBalancedRetryPolicy retryPolicy) {
        RetryTemplate template = new RetryTemplate();
        BackOffPolicy backOffPolicy = this.lbRetryFactory.createBackOffPolicy(serviceName);
        template.setBackOffPolicy((BackOffPolicy)(backOffPolicy == null ? new NoBackOffPolicy() : backOffPolicy));
        template.setThrowLastExceptionOnExhausted(true);
        RetryListener[] retryListeners = this.lbRetryFactory.createRetryListeners(serviceName);
        if (retryListeners != null && retryListeners.length != 0) {
            template.setListeners(retryListeners);
        }
        template.setRetryPolicy((RetryPolicy)(!this.lbProperties.isEnabled() || retryPolicy == null ? new NeverRetryPolicy() : new InterceptorRetryPolicy(request, retryPolicy, this.loadBalancer, serviceName)));
        return template;
    }
}

