/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import okhttp3.OkHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;

public class DefaultOkHttpClientFactory
implements OkHttpClientFactory {
    private static final Log LOG = LogFactory.getLog(DefaultOkHttpClientFactory.class);
    private OkHttpClient.Builder builder;

    public DefaultOkHttpClientFactory(OkHttpClient.Builder builder) {
        this.builder = builder;
    }

    @Override
    public OkHttpClient.Builder createBuilder(boolean disableSslValidation) {
        if (disableSslValidation) {
            try {
                OkHttpClientFactory.DisableValidationTrustManager disabledTrustManager = new OkHttpClientFactory.DisableValidationTrustManager();
                TrustManager[] trustManagers = new TrustManager[]{disabledTrustManager};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustManagers, new SecureRandom());
                SSLSocketFactory disabledSSLSocketFactory = sslContext.getSocketFactory();
                this.builder.sslSocketFactory(disabledSSLSocketFactory, disabledTrustManager);
                this.builder.hostnameVerifier(new OkHttpClientFactory.TrustAllHostnames());
            }
            catch (NoSuchAlgorithmException e) {
                LOG.warn("Error setting SSLSocketFactory in OKHttpClient", e);
            }
            catch (KeyManagementException e) {
                LOG.warn("Error setting SSLSocketFactory in OKHttpClient", e);
            }
        }
        return this.builder;
    }
}

