/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.XnioIoThread;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.ByteChannel;
import org.xnio.channels.CloseableChannel;
import org.xnio.channels.Configurable;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.ReadableMessageChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.SuspendableReadChannel;
import org.xnio.channels.SuspendableWriteChannel;
import org.xnio.channels.WrappedChannel;
import org.xnio.channels.WritableMessageChannel;

public final class Channels {
    private static final FileChannel NULL_FILE_CHANNEL;
    private static final ByteBuffer DRAIN_BUFFER;

    private Channels() {
    }

    public static void flushBlocking(SuspendableWriteChannel channel) throws IOException {
        while (!channel.flush()) {
            channel.awaitWritable();
        }
    }

    public static boolean flushBlocking(SuspendableWriteChannel channel, long time, TimeUnit unit) throws IOException {
        if (channel.flush()) {
            return true;
        }
        long remaining = unit.toNanos(time);
        long now = System.nanoTime();
        do {
            channel.awaitWritable(remaining, TimeUnit.NANOSECONDS);
            if (!channel.flush()) continue;
            return true;
        } while ((remaining -= Math.max(-now + (now = System.nanoTime()), 0L)) > 0L);
        return false;
    }

    public static void shutdownWritesBlocking(SuspendableWriteChannel channel) throws IOException {
        channel.shutdownWrites();
        Channels.flushBlocking(channel);
    }

    public static boolean shutdownWritesBlocking(SuspendableWriteChannel channel, long time, TimeUnit unit) throws IOException {
        channel.shutdownWrites();
        return Channels.flushBlocking(channel, time, unit);
    }

    public static <C extends WritableByteChannel & SuspendableWriteChannel> int writeBlocking(C channel, ByteBuffer buffer) throws IOException {
        int t = 0;
        while (buffer.hasRemaining()) {
            int res = channel.write(buffer);
            if (res == 0) {
                ((SuspendableWriteChannel)channel).awaitWritable();
                continue;
            }
            t += res;
        }
        return t;
    }

    public static <C extends WritableByteChannel & SuspendableWriteChannel> int writeBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        long remaining = unit.toNanos(time);
        long now = System.nanoTime();
        int t = 0;
        while (buffer.hasRemaining() && remaining > 0L) {
            int res = channel.write(buffer);
            if (res == 0) {
                ((SuspendableWriteChannel)channel).awaitWritable(remaining, TimeUnit.NANOSECONDS);
                long l = -now;
                now = System.nanoTime();
                remaining -= Math.max(l + now, 0L);
                continue;
            }
            t += res;
        }
        return t;
    }

    public static <C extends GatheringByteChannel & SuspendableWriteChannel> long writeBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        long t = 0L;
        while (Buffers.hasRemaining(buffers, offs, len)) {
            long res = channel.write(buffers, offs, len);
            if (res == 0L) {
                ((SuspendableWriteChannel)channel).awaitWritable();
                continue;
            }
            t += res;
        }
        return t;
    }

    public static <C extends GatheringByteChannel & SuspendableWriteChannel> long writeBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long remaining = unit.toNanos(time);
        long now = System.nanoTime();
        long t = 0L;
        while (Buffers.hasRemaining(buffers, offs, len) && remaining > 0L) {
            long res = channel.write(buffers, offs, len);
            if (res == 0L) {
                ((SuspendableWriteChannel)channel).awaitWritable(remaining, TimeUnit.NANOSECONDS);
                long l = -now;
                now = System.nanoTime();
                remaining -= Math.max(l + now, 0L);
                continue;
            }
            t += res;
        }
        return t;
    }

    public static <C extends WritableMessageChannel> void sendBlocking(C channel, ByteBuffer buffer) throws IOException {
        while (!channel.send(buffer)) {
            channel.awaitWritable();
        }
    }

    public static <C extends WritableMessageChannel> boolean sendBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        long l;
        long now = System.nanoTime();
        for (long remaining = unit.toNanos(time); remaining > 0L; remaining -= Math.max(l + now, 0L)) {
            if (!channel.send(buffer)) {
                channel.awaitWritable(remaining, TimeUnit.NANOSECONDS);
                l = -now;
                now = System.nanoTime();
                continue;
            }
            return true;
        }
        return false;
    }

    public static <C extends WritableMessageChannel> void sendBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        while (!channel.send(buffers, offs, len)) {
            channel.awaitWritable();
        }
    }

    public static <C extends WritableMessageChannel> boolean sendBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long l;
        long now = System.nanoTime();
        for (long remaining = unit.toNanos(time); remaining > 0L; remaining -= Math.max(l + now, 0L)) {
            if (!channel.send(buffers, offs, len)) {
                channel.awaitWritable(remaining, TimeUnit.NANOSECONDS);
                l = -now;
                now = System.nanoTime();
                continue;
            }
            return true;
        }
        return false;
    }

    public static <C extends ReadableByteChannel & SuspendableReadChannel> int readBlocking(C channel, ByteBuffer buffer) throws IOException {
        int res;
        while ((res = channel.read(buffer)) == 0 && buffer.hasRemaining()) {
            ((SuspendableReadChannel)channel).awaitReadable();
        }
        return res;
    }

    public static <C extends ReadableByteChannel & SuspendableReadChannel> int readBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        long l;
        int res = channel.read(buffer);
        if (res != 0) {
            return res;
        }
        long now = System.nanoTime();
        for (long remaining = unit.toNanos(time); buffer.hasRemaining() && remaining > 0L; remaining -= Math.max(l + now, 0L)) {
            ((SuspendableReadChannel)channel).awaitReadable(remaining, TimeUnit.NANOSECONDS);
            res = channel.read(buffer);
            if (res != 0) {
                return res;
            }
            l = -now;
            now = System.nanoTime();
        }
        return res;
    }

    public static <C extends ScatteringByteChannel & SuspendableReadChannel> long readBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        long res;
        while ((res = channel.read(buffers, offs, len)) == 0L) {
            ((SuspendableReadChannel)channel).awaitReadable();
        }
        return res;
    }

    public static <C extends ScatteringByteChannel & SuspendableReadChannel> long readBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long l;
        long res = channel.read(buffers, offs, len);
        if (res != 0L) {
            return res;
        }
        long now = System.nanoTime();
        for (long remaining = unit.toNanos(time); Buffers.hasRemaining(buffers, offs, len) && remaining > 0L; remaining -= Math.max(l + now, 0L)) {
            ((SuspendableReadChannel)channel).awaitReadable(remaining, TimeUnit.NANOSECONDS);
            res = channel.read(buffers, offs, len);
            if (res != 0L) {
                return res;
            }
            l = -now;
            now = System.nanoTime();
        }
        return res;
    }

    public static <C extends ReadableMessageChannel> int receiveBlocking(C channel, ByteBuffer buffer) throws IOException {
        int res;
        while ((res = channel.receive(buffer)) == 0) {
            channel.awaitReadable();
        }
        return res;
    }

    public static <C extends ReadableMessageChannel> int receiveBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        long l;
        int res = channel.receive(buffer);
        if (res != 0) {
            return res;
        }
        long now = System.nanoTime();
        for (long remaining = unit.toNanos(time); buffer.hasRemaining() && remaining > 0L; remaining -= Math.max(l + now, 0L)) {
            channel.awaitReadable(remaining, TimeUnit.NANOSECONDS);
            res = channel.receive(buffer);
            if (res != 0) {
                return res;
            }
            l = -now;
            now = System.nanoTime();
        }
        return res;
    }

    public static <C extends ReadableMessageChannel> long receiveBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        long res;
        while ((res = channel.receive(buffers, offs, len)) == 0L) {
            channel.awaitReadable();
        }
        return res;
    }

    public static <C extends ReadableMessageChannel> long receiveBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long l;
        long res = channel.receive(buffers, offs, len);
        if (res != 0L) {
            return res;
        }
        long now = System.nanoTime();
        for (long remaining = unit.toNanos(time); Buffers.hasRemaining(buffers, offs, len) && remaining > 0L; remaining -= Math.max(l + now, 0L)) {
            channel.awaitReadable(remaining, TimeUnit.NANOSECONDS);
            res = channel.receive(buffers, offs, len);
            if (res != 0L) {
                return res;
            }
            l = -now;
            now = System.nanoTime();
        }
        return res;
    }

    public static <C extends ConnectedChannel, A extends AcceptingChannel<C>> C acceptBlocking(A channel) throws IOException {
        CloseableChannel accepted;
        while ((accepted = channel.accept()) == null) {
            channel.awaitAcceptable();
        }
        return (C)accepted;
    }

    public static <C extends ConnectedChannel, A extends AcceptingChannel<C>> C acceptBlocking(A channel, long time, TimeUnit unit) throws IOException {
        CloseableChannel accepted = channel.accept();
        if (accepted == null) {
            channel.awaitAcceptable(time, unit);
            return (C)channel.accept();
        }
        return (C)accepted;
    }

    public static void transferBlocking(StreamSinkChannel destination, FileChannel source2, long startPosition, long count) throws IOException {
        long remaining = count;
        while (remaining > 0L) {
            long res;
            while ((res = destination.transferFrom(source2, startPosition, remaining)) == 0L) {
                try {
                    destination.awaitWritable();
                }
                catch (InterruptedIOException e) {
                    long bytes = count - remaining;
                    if (bytes > Integer.MAX_VALUE) {
                        e.bytesTransferred = -1;
                        continue;
                    }
                    e.bytesTransferred = (int)bytes;
                }
            }
            remaining -= res;
            startPosition += res;
        }
    }

    public static void transferBlocking(FileChannel destination, StreamSourceChannel source2, long startPosition, long count) throws IOException {
        long remaining = count;
        while (remaining > 0L) {
            long res;
            while ((res = source2.transferTo(startPosition, remaining, destination)) == 0L) {
                try {
                    source2.awaitReadable();
                }
                catch (InterruptedIOException e) {
                    long bytes = count - remaining;
                    if (bytes > Integer.MAX_VALUE) {
                        e.bytesTransferred = -1;
                        continue;
                    }
                    e.bytesTransferred = (int)bytes;
                }
            }
            remaining -= res;
            startPosition += res;
        }
    }

    public static long transferBlocking(StreamSinkChannel destination, StreamSourceChannel source2, ByteBuffer throughBuffer, long count) throws IOException {
        long t;
        long res;
        for (t = 0L; t < count; t += res) {
            try {
                while ((res = source2.transferTo(count, throughBuffer, destination)) == 0L) {
                    if (throughBuffer.hasRemaining()) {
                        Channels.writeBlocking(destination, throughBuffer);
                        continue;
                    }
                    source2.awaitReadable();
                }
                continue;
            }
            catch (InterruptedIOException e) {
                int transferred = e.bytesTransferred;
                e.bytesTransferred = transferred < 0 || t > Integer.MAX_VALUE ? -1 : (int)(t += (long)transferred);
                throw e;
            }
        }
        return t;
    }

    public static <T extends CloseableChannel> void setCloseListener(T channel, ChannelListener<? super T> listener) {
        ChannelListener.Setter<? extends CloseableChannel> setter = channel.getCloseSetter();
        setter.set(listener);
    }

    public static <T extends AcceptingChannel<?>> void setAcceptListener(T channel, ChannelListener<? super T> listener) {
        ChannelListener.Setter<AcceptingChannel<?>> setter = channel.getAcceptSetter();
        setter.set(listener);
    }

    public static <T extends SuspendableReadChannel> void setReadListener(T channel, ChannelListener<? super T> listener) {
        ChannelListener.Setter<? extends SuspendableReadChannel> setter = channel.getReadSetter();
        setter.set(listener);
    }

    public static <T extends SuspendableWriteChannel> void setWriteListener(T channel, ChannelListener<? super T> listener) {
        ChannelListener.Setter<? extends SuspendableWriteChannel> setter = channel.getWriteSetter();
        setter.set(listener);
    }

    public static ByteChannel wrapByteChannel(final ByteChannel original) {
        return new ByteChannel(){

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return original.read(dst);
            }

            @Override
            public boolean isOpen() {
                return original.isOpen();
            }

            @Override
            public void close() throws IOException {
                original.close();
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return original.write(src);
            }

            @Override
            public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                return original.write(srcs, offset, length);
            }

            @Override
            public long write(ByteBuffer[] srcs) throws IOException {
                return original.write(srcs);
            }

            @Override
            public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
                return original.read(dsts, offset, length);
            }

            @Override
            public long read(ByteBuffer[] dsts) throws IOException {
                return original.read(dsts);
            }
        };
    }

    public static <T> T getOption(Configurable configurable, Option<T> option, T defaultValue) {
        try {
            T value = configurable.getOption(option);
            return value == null ? defaultValue : value;
        }
        catch (IOException e) {
            return defaultValue;
        }
    }

    public static boolean getOption(Configurable configurable, Option<Boolean> option, boolean defaultValue) {
        try {
            Boolean value = configurable.getOption(option);
            return value == null ? defaultValue : value;
        }
        catch (IOException e) {
            return defaultValue;
        }
    }

    public static int getOption(Configurable configurable, Option<Integer> option, int defaultValue) {
        try {
            Integer value = configurable.getOption(option);
            return value == null ? defaultValue : value;
        }
        catch (IOException e) {
            return defaultValue;
        }
    }

    public static long getOption(Configurable configurable, Option<Long> option, long defaultValue) {
        try {
            Long value = configurable.getOption(option);
            return value == null ? defaultValue : value;
        }
        catch (IOException e) {
            return defaultValue;
        }
    }

    public static <T extends Channel> T unwrap(Class<T> targetType, Channel channel) {
        while (true) {
            if (channel == null) {
                return null;
            }
            if (targetType.isInstance(channel)) {
                return (T)((Channel)targetType.cast(channel));
            }
            if (!(channel instanceof WrappedChannel)) break;
            channel = ((WrappedChannel)((Object)channel)).getChannel();
        }
        return null;
    }

    public static long drain(StreamSourceChannel channel, long count) throws IOException {
        long total = 0L;
        Buffer buffer = null;
        while (count != 0L) {
            if (NULL_FILE_CHANNEL != null) {
                long lres;
                while (count > 0L && (lres = channel.transferTo(0L, count, NULL_FILE_CHANNEL)) != 0L) {
                    total += lres;
                    count -= lres;
                }
                if (total > 0L) {
                    return total;
                }
            }
            if (buffer == null) {
                buffer = DRAIN_BUFFER.duplicate();
            }
            if ((long)buffer.limit() > count) {
                ((ByteBuffer)buffer).limit((int)count);
            }
            int ires = channel.read((ByteBuffer)buffer);
            ((ByteBuffer)buffer).clear();
            switch (ires) {
                case -1: {
                    return total == 0L ? -1L : total;
                }
                case 0: {
                    return total;
                }
            }
            total += (long)ires;
            count -= (long)ires;
        }
        return total;
    }

    public static long drain(ReadableByteChannel channel, long count) throws IOException {
        if (channel instanceof StreamSourceChannel) {
            return Channels.drain((StreamSourceChannel)channel, count);
        }
        long total = 0L;
        Buffer buffer = null;
        while (count != 0L) {
            if (NULL_FILE_CHANNEL != null) {
                long lres;
                while (count > 0L && (lres = NULL_FILE_CHANNEL.transferFrom(channel, 0L, count)) != 0L) {
                    total += lres;
                    count -= lres;
                }
                if (total > 0L) {
                    return total;
                }
            }
            if (buffer == null) {
                buffer = DRAIN_BUFFER.duplicate();
            }
            if ((long)buffer.limit() > count) {
                ((ByteBuffer)buffer).limit((int)count);
            }
            int ires = channel.read((ByteBuffer)buffer);
            ((ByteBuffer)buffer).clear();
            switch (ires) {
                case -1: {
                    return total == 0L ? -1L : total;
                }
                case 0: {
                    return total;
                }
            }
            total += (long)ires;
            count -= (long)ires;
        }
        return total;
    }

    public static long drain(FileChannel channel, long position, long count) throws IOException {
        if (channel instanceof StreamSourceChannel) {
            return Channels.drain((StreamSourceChannel)((Object)channel), count);
        }
        long total = 0L;
        Buffer buffer = null;
        while (count != 0L) {
            if (NULL_FILE_CHANNEL != null) {
                long lres;
                while (count > 0L && (lres = channel.transferTo(position, count, NULL_FILE_CHANNEL)) != 0L) {
                    total += lres;
                    count -= lres;
                }
                if (total > 0L) {
                    return total;
                }
            }
            if (buffer == null) {
                buffer = DRAIN_BUFFER.duplicate();
            }
            if ((long)buffer.limit() > count) {
                ((ByteBuffer)buffer).limit((int)count);
            }
            int ires = channel.read((ByteBuffer)buffer);
            ((ByteBuffer)buffer).clear();
            switch (ires) {
                case -1: {
                    return total == 0L ? -1L : total;
                }
                case 0: {
                    return total;
                }
            }
            total += (long)ires;
        }
        return total;
    }

    public static void resumeReadsAsync(final SuspendableReadChannel channel) {
        XnioIoThread ioThread = channel.getIoThread();
        if (ioThread == Thread.currentThread()) {
            channel.resumeReads();
        } else {
            ioThread.execute(new Runnable(){

                @Override
                public void run() {
                    channel.resumeReads();
                }
            });
        }
    }

    public static void resumeWritesAsync(final SuspendableWriteChannel channel) {
        XnioIoThread ioThread = channel.getIoThread();
        if (ioThread == Thread.currentThread()) {
            channel.resumeWrites();
        } else {
            ioThread.execute(new Runnable(){

                @Override
                public void run() {
                    channel.resumeWrites();
                }
            });
        }
    }

    public static int writeFinalBasic(StreamSinkChannel channel, ByteBuffer src) throws IOException {
        int res = channel.write(src);
        if (!src.hasRemaining()) {
            channel.shutdownWrites();
        }
        return res;
    }

    public static long writeFinalBasic(StreamSinkChannel channel, ByteBuffer[] srcs, int offset, int length) throws IOException {
        long res = channel.write(srcs, offset, length);
        if (!Buffers.hasRemaining(srcs, offset, length)) {
            channel.shutdownWrites();
        }
        return res;
    }

    static {
        DRAIN_BUFFER = ByteBuffer.allocateDirect(16384);
        NULL_FILE_CHANNEL = AccessController.doPrivileged(new PrivilegedAction<FileChannel>(){

            @Override
            public FileChannel run() {
                String osName = System.getProperty("os.name", "unknown").toLowerCase(Locale.US);
                try {
                    if (osName.contains("windows")) {
                        return new FileOutputStream("NUL:").getChannel();
                    }
                    return new FileOutputStream("/dev/null").getChannel();
                }
                catch (FileNotFoundException e) {
                    throw new IOError(e);
                }
            }
        });
    }
}

