/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import org.xnio.Buffers;
import org.xnio.conduits.MessageSinkConduit;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class Conduits {
    private static final FileChannel NULL_FILE_CHANNEL;
    private static final ByteBuffer DRAIN_BUFFER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transfer(StreamSourceConduit source2, long count, ByteBuffer throughBuffer, WritableByteChannel sink2) throws IOException {
        long total;
        long res;
        throughBuffer.limit(0);
        for (total = 0L; total < count; total += res) {
            throughBuffer.compact();
            try {
                if (count - total < (long)throughBuffer.remaining()) {
                    throughBuffer.limit((int)(count - total));
                }
                if ((res = (long)source2.read(throughBuffer)) <= 0L) {
                    long l = total == 0L ? res : total;
                    return l;
                }
            }
            finally {
                throughBuffer.flip();
            }
            res = sink2.write(throughBuffer);
            if (res != 0L) continue;
            return total;
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transfer(ReadableByteChannel source2, long count, ByteBuffer throughBuffer, StreamSinkConduit sink2) throws IOException {
        long total;
        long res;
        throughBuffer.limit(0);
        for (total = 0L; total < count; total += res) {
            throughBuffer.compact();
            try {
                if (count - total < (long)throughBuffer.remaining()) {
                    throughBuffer.limit((int)(count - total));
                }
                if ((res = (long)source2.read(throughBuffer)) <= 0L) {
                    long l = total == 0L ? res : total;
                    return l;
                }
            }
            finally {
                throughBuffer.flip();
            }
            res = sink2.write(throughBuffer);
            if (res != 0L) continue;
            return total;
        }
        return total;
    }

    public static int writeFinalBasic(StreamSinkConduit conduit, ByteBuffer src) throws IOException {
        int res = conduit.write(src);
        if (!src.hasRemaining()) {
            conduit.terminateWrites();
        }
        return res;
    }

    public static long writeFinalBasic(StreamSinkConduit conduit, ByteBuffer[] srcs, int offset, int length) throws IOException {
        long res = conduit.write(srcs, offset, length);
        if (!Buffers.hasRemaining(srcs, offset, length)) {
            conduit.terminateWrites();
        }
        return res;
    }

    public static boolean sendFinalBasic(MessageSinkConduit conduit, ByteBuffer src) throws IOException {
        if (conduit.send(src)) {
            conduit.terminateWrites();
            return true;
        }
        return false;
    }

    public static boolean sendFinalBasic(MessageSinkConduit conduit, ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (conduit.send(srcs, offset, length)) {
            conduit.terminateWrites();
            return true;
        }
        return false;
    }

    public static long drain(StreamSourceConduit conduit, long count) throws IOException {
        long total = 0L;
        Buffer buffer = null;
        while (count != 0L) {
            if (NULL_FILE_CHANNEL != null) {
                long lres;
                while (count > 0L && (lres = conduit.transferTo(0L, count, NULL_FILE_CHANNEL)) != 0L) {
                    total += lres;
                    count -= lres;
                }
                if (total > 0L) {
                    return total;
                }
            }
            if (buffer == null) {
                buffer = DRAIN_BUFFER.duplicate();
            }
            if ((long)buffer.limit() > count) {
                ((ByteBuffer)buffer).limit((int)count);
            }
            int ires = conduit.read((ByteBuffer)buffer);
            ((ByteBuffer)buffer).clear();
            switch (ires) {
                case -1: {
                    return total == 0L ? -1L : total;
                }
                case 0: {
                    return total;
                }
            }
            total += (long)ires;
        }
        return total;
    }

    static {
        DRAIN_BUFFER = ByteBuffer.allocateDirect(16384);
        NULL_FILE_CHANNEL = AccessController.doPrivileged(new PrivilegedAction<FileChannel>(){

            @Override
            public FileChannel run() {
                String osName = System.getProperty("os.name", "unknown").toLowerCase(Locale.US);
                try {
                    if (osName.contains("windows")) {
                        return new FileOutputStream("NUL:").getChannel();
                    }
                    return new FileOutputStream("/dev/null").getChannel();
                }
                catch (FileNotFoundException e) {
                    throw new IOError(e);
                }
            }
        });
    }
}

