/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio._private.Messages;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.JsseSslStreamConnection;

final class JsseSslConduitEngine {
    private static final Logger log = Logger.getLogger("org.xnio.conduits");
    private static final String FQCN = JsseSslConduitEngine.class.getName();
    private static final int NEED_WRAP = 1;
    private static final int READ_SHUT_DOWN = 2;
    private static final int BUFFER_UNDERFLOW = 4;
    private static final int READ_FLAGS = Bits.intBitMask(0, 15);
    private static final int NEED_UNWRAP = 65536;
    private static final int WRITE_SHUT_DOWN = 131072;
    private static final int WRITE_COMPLETE = 262144;
    private static final int FIRST_HANDSHAKE = 0x400000;
    private static final int ENGINE_CLOSED = 0x800000;
    private static final int WRITE_FLAGS = Bits.intBitMask(16, 31);
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final SSLEngine engine;
    private final Pooled<ByteBuffer> receiveBuffer;
    private final Pooled<ByteBuffer> sendBuffer;
    private ByteBuffer expandedSendBuffer;
    private final Pooled<ByteBuffer> readBuffer;
    private final StreamSinkConduit sinkConduit;
    private final StreamSourceConduit sourceConduit;
    private final JsseSslStreamConnection connection;
    private volatile int state;
    private static final AtomicIntegerFieldUpdater<JsseSslConduitEngine> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(JsseSslConduitEngine.class, "state");
    private volatile Thread readWaiter;
    private volatile Thread writeWaiter;
    private static final AtomicReferenceFieldUpdater<JsseSslConduitEngine, Thread> readWaiterUpdater = AtomicReferenceFieldUpdater.newUpdater(JsseSslConduitEngine.class, Thread.class, "readWaiter");
    private static final AtomicReferenceFieldUpdater<JsseSslConduitEngine, Thread> writeWaiterUpdater = AtomicReferenceFieldUpdater.newUpdater(JsseSslConduitEngine.class, Thread.class, "writeWaiter");
    private int failureCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JsseSslConduitEngine(JsseSslStreamConnection connection, StreamSinkConduit sinkConduit, StreamSourceConduit sourceConduit, SSLEngine engine, Pool<ByteBuffer> socketBufferPool, Pool<ByteBuffer> applicationBufferPool) {
        if (connection == null) {
            throw Messages.msg.nullParameter("connection");
        }
        if (sinkConduit == null) {
            throw Messages.msg.nullParameter("sinkConduit");
        }
        if (sourceConduit == null) {
            throw Messages.msg.nullParameter("sourceConduit");
        }
        if (engine == null) {
            throw Messages.msg.nullParameter("engine");
        }
        if (socketBufferPool == null) {
            throw Messages.msg.nullParameter("socketBufferPool");
        }
        if (applicationBufferPool == null) {
            throw Messages.msg.nullParameter("applicationBufferPool");
        }
        this.connection = connection;
        this.sinkConduit = sinkConduit;
        this.sourceConduit = sourceConduit;
        this.engine = engine;
        this.state = 0x400000;
        SSLSession session = engine.getSession();
        int packetBufferSize = session.getPacketBufferSize();
        boolean ok = false;
        this.receiveBuffer = socketBufferPool.allocate();
        try {
            this.receiveBuffer.getResource().flip();
            this.sendBuffer = socketBufferPool.allocate();
            try {
                if (this.receiveBuffer.getResource().capacity() < packetBufferSize || this.sendBuffer.getResource().capacity() < packetBufferSize) {
                    this.expandedSendBuffer = ByteBuffer.allocate(packetBufferSize);
                }
                this.readBuffer = applicationBufferPool.allocate();
                ok = true;
            }
            finally {
                if (!ok) {
                    this.sendBuffer.free();
                }
            }
        }
        finally {
            if (!ok) {
                this.receiveBuffer.free();
            }
        }
    }

    public void beginHandshake() throws IOException {
        this.engine.beginHandshake();
    }

    public SSLSession getSession() {
        return this.engine.getSession();
    }

    public int wrap(ByteBuffer src) throws IOException {
        return this.wrap(src, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long wrap(ByteBuffer[] srcs, int offset, int length) throws IOException {
        assert (!Thread.holdsLock(this.getWrapLock()));
        assert (!Thread.holdsLock(this.getUnwrapLock()));
        if (length < 1) {
            return 0L;
        }
        if (Bits.allAreSet(this.state, 262144)) {
            throw new ClosedChannelException();
        }
        long bytesConsumed = 0L;
        try {
            SSLEngineResult result;
            boolean run;
            do {
                Object object = this.getWrapLock();
                synchronized (object) {
                    result = this.engineWrap(srcs, offset, length, this.getSendBuffer());
                    run = this.handleWrapResult(result, false);
                    bytesConsumed += (long)result.bytesConsumed();
                }
            } while (run = run && (this.handleHandshake(result, true) || !this.isUnwrapNeeded() && Buffers.hasRemaining(srcs, offset, length)));
        }
        catch (SSLHandshakeException e) {
            try {
                Object object = this.getWrapLock();
                synchronized (object) {
                    this.engine.wrap(EMPTY_BUFFER, this.getSendBuffer());
                    this.doFlush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        return bytesConsumed;
    }

    public ByteBuffer getWrappedBuffer() {
        assert (Thread.holdsLock(this.getWrapLock()));
        assert (!Thread.holdsLock(this.getUnwrapLock()));
        return Bits.allAreSet(stateUpdater.get(this), 0x800000) ? Buffers.EMPTY_BYTE_BUFFER : this.getSendBuffer();
    }

    public Object getWrapLock() {
        return this.sendBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int wrap(ByteBuffer src, boolean isCloseExpected) throws IOException {
        assert (!Thread.holdsLock(this.getWrapLock()));
        assert (!Thread.holdsLock(this.getUnwrapLock()));
        if (Bits.allAreSet(this.state, 262144)) {
            throw new ClosedChannelException();
        }
        this.clearFlags(0x400000);
        int bytesConsumed = 0;
        try {
            SSLEngineResult result;
            boolean run;
            do {
                Object object = this.getWrapLock();
                synchronized (object) {
                    result = this.engineWrap(src, this.getSendBuffer());
                    run = this.handleWrapResult(result, isCloseExpected);
                }
            } while (run = run && (bytesConsumed += result.bytesConsumed()) == 0 && (this.handleHandshake(result, true) || !this.isUnwrapNeeded() && src.hasRemaining()));
        }
        catch (SSLHandshakeException e) {
            try {
                Object object = this.getWrapLock();
                synchronized (object) {
                    this.engine.wrap(EMPTY_BUFFER, this.getSendBuffer());
                    this.doFlush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        return bytesConsumed;
    }

    private SSLEngineResult engineWrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dest) throws SSLException {
        assert (Thread.holdsLock(this.getWrapLock()));
        assert (!Thread.holdsLock(this.getUnwrapLock()));
        log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Wrapping %s into %s", (Object)srcs, (Object)dest);
        try {
            return this.engine.wrap(srcs, offset, length, dest);
        }
        catch (SSLHandshakeException e) {
            try {
                this.engine.wrap(srcs, offset, length, dest);
                this.doFlush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private SSLEngineResult engineWrap(ByteBuffer src, ByteBuffer dest) throws SSLException {
        assert (Thread.holdsLock(this.getWrapLock()));
        assert (!Thread.holdsLock(this.getUnwrapLock()));
        log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Wrapping %s into %s", (Object)src, (Object)dest);
        return this.engine.wrap(src, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleWrapResult(SSLEngineResult result, boolean closeExpected) throws IOException {
        assert (Thread.holdsLock(this.getWrapLock()));
        assert (!Thread.holdsLock(this.getUnwrapLock()));
        log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Wrap result is %s", (Object)result);
        switch (result.getStatus()) {
            case BUFFER_UNDERFLOW: {
                assert (result.bytesConsumed() == 0);
                assert (result.bytesProduced() == 0);
                break;
            }
            case BUFFER_OVERFLOW: {
                assert (result.bytesConsumed() == 0);
                assert (result.bytesProduced() == 0);
                ByteBuffer buffer = this.getSendBuffer();
                if (buffer.position() == 0) {
                    int bufferSize = this.engine.getSession().getPacketBufferSize();
                    if (buffer.capacity() < bufferSize) {
                        Messages.msg.expandedSslBufferEnabled(bufferSize);
                        this.expandedSendBuffer = ByteBuffer.allocate(bufferSize);
                        break;
                    }
                    throw Messages.msg.wrongBufferExpansion();
                }
                buffer.flip();
                try {
                    while (buffer.hasRemaining()) {
                        int res = this.sinkConduit.write(buffer);
                        if (res != 0) continue;
                        boolean bl = false;
                        return bl;
                    }
                    break;
                }
                finally {
                    buffer.compact();
                }
            }
            case CLOSED: {
                if (!closeExpected) {
                    throw new ClosedChannelException();
                }
            }
            case OK: {
                if (result.bytesConsumed() != 0 || result.bytesProduced() <= 0 || this.doFlush()) break;
                return false;
            }
            default: {
                throw Messages.msg.unexpectedWrapResult(result.getStatus());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleHandshake(SSLEngineResult result, boolean write) throws IOException {
        assert (!Thread.holdsLock(this.getUnwrapLock()));
        if (this.isWrapNeeded()) {
            Object object = this.getWrapLock();
            synchronized (object) {
                if (this.doFlush()) {
                    this.clearNeedWrap();
                }
            }
        }
        boolean newResult = false;
        block27: while (true) {
            switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[result.getHandshakeStatus().ordinal()]) {
                case 1: {
                    this.clearNeedUnwrap();
                    this.connection.handleHandshakeFinished();
                    return true;
                }
                case 2: {
                    this.clearNeedUnwrap();
                    return false;
                }
                case 3: {
                    this.clearNeedUnwrap();
                    if (write) {
                        return true;
                    }
                    Object buffer = this.getSendBuffer();
                    Object object = this.getWrapLock();
                    synchronized (object) {
                        if (this.doFlush()) {
                            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                                this.closeOutbound();
                                return false;
                            }
                            result = this.engineWrap(Buffers.EMPTY_BYTE_BUFFER, (ByteBuffer)buffer);
                            if (!this.handleWrapResult(result, true) || !this.doFlush()) {
                                this.needWrap();
                                return false;
                            }
                            newResult = true;
                            this.clearNeedWrap();
                            continue block27;
                        }
                        assert (!this.isUnwrapNeeded());
                        this.needWrap();
                        return false;
                    }
                }
                case 4: {
                    Object object;
                    if (!write) {
                        return newResult;
                    }
                    Object buffer = this.getWrapLock();
                    synchronized (buffer) {
                        this.doFlush();
                    }
                    buffer = this.receiveBuffer.getResource();
                    ByteBuffer unwrappedBuffer = this.readBuffer.getResource();
                    if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && this.engine.isOutboundDone()) {
                        object = this.getUnwrapLock();
                        synchronized (object) {
                            ((ByteBuffer)buffer).compact();
                            this.sourceConduit.read((ByteBuffer)buffer);
                            ((ByteBuffer)buffer).flip();
                            if (((Buffer)buffer).hasRemaining() && this.sourceConduit.isReadResumed()) {
                                this.sourceConduit.wakeupReads();
                            }
                            return false;
                        }
                    }
                    object = this.getUnwrapLock();
                    synchronized (object) {
                        result = this.engineUnwrap((ByteBuffer)buffer, unwrappedBuffer);
                        int unwrapResult = this.handleUnwrapResult(result);
                        if (((Buffer)buffer).hasRemaining() && this.sourceConduit.isReadResumed()) {
                            this.sourceConduit.wakeupReads();
                        }
                        if (unwrapResult >= 0) {
                            if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || result.bytesConsumed() > 0) {
                                this.clearNeedUnwrap();
                                continue block27;
                            }
                            assert (!this.isWrapNeeded());
                            this.needUnwrap();
                            return false;
                        }
                        if (unwrapResult == -1 && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                            if (!Bits.allAreSet(this.state, 2)) {
                                throw new ClosedChannelException();
                            }
                            return false;
                        }
                    }
                }
                continue block27;
                case 5: {
                    Object object = this.engine;
                    synchronized (object) {
                        Runnable task;
                        while ((task = this.engine.getDelegatedTask()) != null) {
                            try {
                                task.run();
                            }
                            catch (Exception e) {
                                throw new IOException(e);
                            }
                        }
                    }
                    return true;
                }
            }
            break;
        }
        throw Messages.msg.unexpectedHandshakeStatus(result.getHandshakeStatus());
    }

    public int unwrap(ByteBuffer dst) throws IOException {
        return (int)this.unwrap(new ByteBuffer[]{dst}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long unwrap(ByteBuffer[] dsts, int offset, int length) throws IOException {
        SSLEngineResult result;
        assert (!Thread.holdsLock(this.getUnwrapLock()));
        assert (!Thread.holdsLock(this.getWrapLock()));
        if (dsts.length == 0 || length == 0 || this.isClosed()) {
            return 0L;
        }
        this.clearFlags(0x400004);
        ByteBuffer buffer = this.receiveBuffer.getResource();
        ByteBuffer unwrappedBuffer = this.readBuffer.getResource();
        long total = 0L;
        Object object = this.getUnwrapLock();
        synchronized (object) {
            if (unwrappedBuffer.position() > 0) {
                total += (long)this.copyUnwrappedData(dsts, offset, length, unwrappedBuffer);
            }
        }
        int res = 0;
        try {
            do {
                Object object2 = this.getUnwrapLock();
                synchronized (object2) {
                    if (!Buffers.hasRemaining(dsts, offset, length)) {
                        if (unwrappedBuffer.hasRemaining() && this.sourceConduit.isReadResumed()) {
                            this.sourceConduit.wakeupReads();
                        }
                        return total;
                    }
                    result = this.engineUnwrap(buffer, unwrappedBuffer);
                    res = this.handleUnwrapResult(result);
                    if (unwrappedBuffer.position() > 0) {
                        total += (long)this.copyUnwrappedData(dsts, offset, length, unwrappedBuffer);
                    }
                }
            } while (this.handleHandshake(result, false) || res > 0);
        }
        catch (SSLHandshakeException e) {
            try {
                Object object3 = this.getWrapLock();
                synchronized (object3) {
                    this.engine.wrap(EMPTY_BUFFER, this.getSendBuffer());
                    this.doFlush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        if (total == 0L && res == -1) {
            return -1L;
        }
        if (res == 0 && result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            int old;
            while (!stateUpdater.compareAndSet(this, old = this.state, old | 4)) {
            }
        }
        return total;
    }

    public ByteBuffer getUnwrapBuffer() {
        assert (Thread.holdsLock(this.getUnwrapLock()));
        assert (!Thread.holdsLock(this.getWrapLock()));
        return this.receiveBuffer.getResource();
    }

    public Object getUnwrapLock() {
        return this.receiveBuffer;
    }

    private SSLEngineResult engineUnwrap(ByteBuffer buffer, ByteBuffer unwrappedBuffer) throws IOException {
        assert (Thread.holdsLock(this.getUnwrapLock()));
        if (!buffer.hasRemaining()) {
            buffer.compact();
            this.sourceConduit.read(buffer);
            buffer.flip();
        }
        log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Unwrapping %s into %s", (Object)buffer, (Object)unwrappedBuffer);
        return this.engine.unwrap(buffer, unwrappedBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyUnwrappedData(ByteBuffer[] dsts, int offset, int length, ByteBuffer unwrappedBuffer) {
        assert (Thread.holdsLock(this.getUnwrapLock()));
        unwrappedBuffer.flip();
        try {
            int n = Buffers.copy(dsts, offset, length, unwrappedBuffer);
            return n;
        }
        finally {
            unwrappedBuffer.compact();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleUnwrapResult(SSLEngineResult result) throws IOException {
        assert (Thread.holdsLock(this.getUnwrapLock()));
        log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Unwrap result is %s", (Object)result);
        switch (result.getStatus()) {
            case BUFFER_OVERFLOW: {
                assert (result.bytesConsumed() == 0);
                assert (result.bytesProduced() == 0);
                return 0;
            }
            case BUFFER_UNDERFLOW: {
                assert (result.bytesConsumed() == 0);
                assert (result.bytesProduced() == 0);
                ByteBuffer buffer = this.receiveBuffer.getResource();
                Object object = this.getUnwrapLock();
                synchronized (object) {
                    int n;
                    buffer.compact();
                    try {
                        n = this.sourceConduit.read(buffer);
                        buffer.flip();
                    }
                    catch (Throwable throwable) {
                        buffer.flip();
                        throw throwable;
                    }
                    return n;
                }
            }
            case CLOSED: {
                if (result.bytesConsumed() > 0) {
                    return result.bytesConsumed();
                }
                return -1;
            }
            case OK: {
                return result.bytesConsumed();
            }
        }
        throw Messages.msg.unexpectedUnwrapResult(result.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() throws IOException {
        int oldState = stateUpdater.get(this);
        if (Bits.allAreSet(oldState, 262144)) {
            if (this.engine.isOutboundDone()) {
                this.connection.writeClosed();
            }
            return true;
        }
        Object object = this.getWrapLock();
        synchronized (object) {
            if (Bits.allAreSet(oldState, 131072)) {
                if (!this.wrapCloseMessage()) {
                    return false;
                }
            } else {
                if (this.engine.isOutboundDone()) {
                    this.connection.writeClosed();
                }
                return true;
            }
        }
        int newState = oldState | 0x40000;
        while (!stateUpdater.compareAndSet(this, oldState, newState)) {
            oldState = stateUpdater.get(this);
            if (Bits.allAreSet(oldState, 262144)) {
                if (this.engine.isOutboundDone()) {
                    this.connection.writeClosed();
                }
                return true;
            }
            newState = oldState | 0x40000;
        }
        if (Bits.allAreSet(oldState, 2)) {
            this.closeEngine();
        }
        if (this.engine.isOutboundDone()) {
            this.connection.writeClosed();
        }
        return true;
    }

    private boolean wrapCloseMessage() throws IOException {
        assert (!Thread.holdsLock(this.getUnwrapLock()));
        assert (Thread.holdsLock(this.getWrapLock()));
        if (this.sinkConduit.isWriteShutdown()) {
            return true;
        }
        if (!this.engine.isOutboundDone() || !this.engine.isInboundDone()) {
            SSLEngineResult result;
            do {
                if (this.handleWrapResult(result = this.engineWrap(Buffers.EMPTY_BYTE_BUFFER, this.getSendBuffer()), true)) continue;
                return false;
            } while (this.handleHandshake(result, true) && (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || !this.engine.isOutboundDone()));
            result = this.engineWrap(Buffers.EMPTY_BYTE_BUFFER, this.getSendBuffer());
            this.handleWrapResult(result, true);
            if (!this.engine.isOutboundDone() || result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush() throws IOException {
        assert (Thread.holdsLock(this.getWrapLock()));
        assert (!Thread.holdsLock(this.getUnwrapLock()));
        ByteBuffer buffer = this.getSendBuffer();
        buffer.flip();
        try {
            while (buffer.hasRemaining()) {
                int res = this.sinkConduit.write(buffer);
                if (res != 0) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            buffer.compact();
        }
        return this.sinkConduit.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeEngine() throws IOException {
        int old = this.setFlags(0x800000);
        if (Bits.allAreSet(old, 0x800000)) {
            return;
        }
        try {
            Object object = this.getWrapLock();
            synchronized (object) {
                if (!this.doFlush()) {
                    throw Messages.msg.unflushedData();
                }
            }
        }
        finally {
            this.readBuffer.free();
            this.receiveBuffer.free();
            this.sendBuffer.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOutbound() throws IOException {
        int old = this.setFlags(131072);
        try {
            if (Bits.allAreClear(old, 131072)) {
                this.engine.closeOutbound();
                Object object = this.getWrapLock();
                synchronized (object) {
                    this.wrapCloseMessage();
                    this.flush();
                }
            }
            if (!Bits.allAreClear(old, 2)) {
                this.closeEngine();
            }
        }
        catch (Exception e) {
            try {
                this.closeEngine();
            }
            catch (Exception closeEngineException) {
                Messages.msg.failedToCloseSSLEngine(e, closeEngineException);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)e;
        }
    }

    void close() throws IOException {
        if (this.isFirstHandshake()) {
            this.setFlags(393218);
            this.closeEngine();
        } else {
            try {
                this.closeInbound();
            }
            finally {
                this.closeOutbound();
            }
        }
    }

    public boolean isOutboundClosed() {
        return Bits.allAreSet(stateUpdater.get(this), 131072);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitCanWrap() throws IOException {
        int oldState = this.state;
        if (Bits.anyAreSet(oldState, 131072) || !Bits.allAreSet(oldState, 65536)) {
            return;
        }
        Thread thread2 = Thread.currentThread();
        Thread next = writeWaiterUpdater.getAndSet(this, thread2);
        try {
            oldState = this.state;
            if (Bits.anyAreSet(oldState, 131072)) {
                return;
            }
            if (Bits.allAreSet(oldState, 65536)) {
                this.unwrap(Buffers.EMPTY_BYTE_BUFFER);
            }
            LockSupport.park(this);
            if (thread2.isInterrupted()) {
                throw Messages.msg.interruptedIO();
            }
        }
        finally {
            if (next != null) {
                LockSupport.unpark(next);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitCanWrap(long time, TimeUnit timeUnit) throws IOException {
        int oldState = this.state;
        if (Bits.anyAreSet(oldState, 131072) || !Bits.allAreSet(oldState, 65536)) {
            return;
        }
        Thread thread2 = Thread.currentThread();
        Thread next = writeWaiterUpdater.getAndSet(this, thread2);
        long duration = timeUnit.toNanos(time);
        try {
            oldState = this.state;
            if (Bits.anyAreSet(oldState, 131072)) {
                return;
            }
            if (Bits.allAreSet(oldState, 65536)) {
                this.unwrap(Buffers.EMPTY_BYTE_BUFFER);
            }
            LockSupport.parkNanos(this, duration);
            if (thread2.isInterrupted()) {
                throw Messages.msg.interruptedIO();
            }
        }
        finally {
            if (next != null) {
                LockSupport.unpark(next);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInbound() throws IOException {
        this.connection.readClosed();
        int old = this.setFlags(2);
        try {
            if (Bits.allAreClear(old, 2)) {
                this.sourceConduit.terminateReads();
            }
            if (Bits.allAreSet(old, 131072) && !Bits.allAreSet(old, 262144)) {
                Object object = this.getWrapLock();
                synchronized (object) {
                    this.wrapCloseMessage();
                    this.flush();
                }
            }
            if (Bits.allAreSet(old, 262144)) {
                this.closeEngine();
            }
        }
        catch (Exception e) {
            this.closeEngine();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)e;
        }
    }

    public boolean isInboundClosed() {
        return Bits.allAreSet(this.state, 2);
    }

    public boolean isClosed() {
        return Bits.allAreSet(this.state, 0x800000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitCanUnwrap() throws IOException {
        int oldState = this.state;
        if (Bits.anyAreSet(oldState, 2) || !Bits.anyAreSet(oldState, 1)) {
            return;
        }
        Thread thread2 = Thread.currentThread();
        Thread next = readWaiterUpdater.getAndSet(this, thread2);
        try {
            oldState = this.state;
            if (Bits.anyAreSet(oldState, 2)) {
                return;
            }
            if (Bits.allAreSet(oldState, 1)) {
                this.wrap(Buffers.EMPTY_BYTE_BUFFER);
            }
            LockSupport.park(this);
            if (thread2.isInterrupted()) {
                throw Messages.msg.interruptedIO();
            }
        }
        finally {
            if (next != null) {
                LockSupport.unpark(next);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitCanUnwrap(long time, TimeUnit timeUnit) throws IOException {
        int oldState = this.state;
        if (Bits.anyAreSet(oldState, 2) || !Bits.anyAreSet(oldState, 1)) {
            return;
        }
        Thread thread2 = Thread.currentThread();
        Thread next = readWaiterUpdater.getAndSet(this, thread2);
        long duration = timeUnit.toNanos(time);
        try {
            oldState = this.state;
            if (Bits.anyAreSet(oldState, 2)) {
                return;
            }
            if (Bits.allAreSet(oldState, 1)) {
                this.wrap(Buffers.EMPTY_BYTE_BUFFER);
            }
            LockSupport.parkNanos(this, duration);
            if (thread2.isInterrupted()) {
                throw Messages.msg.interruptedIO();
            }
        }
        finally {
            if (next != null) {
                LockSupport.unpark(next);
            }
        }
    }

    public boolean isFirstHandshake() {
        return Bits.allAreSet(this.state, 0x400000);
    }

    SSLEngine getEngine() {
        return this.engine;
    }

    private void needWrap() {
        this.setFlags(1);
    }

    private boolean isWrapNeeded() {
        return Bits.allAreSet(this.state, 1);
    }

    private void clearNeedWrap() {
        this.clearFlags(1);
    }

    private void needUnwrap() {
        this.setFlags(65536);
    }

    private boolean isUnwrapNeeded() {
        return Bits.allAreSet(this.state, 65536);
    }

    private boolean isUnderflow() {
        return Bits.allAreSet(this.state, 4);
    }

    private void clearNeedUnwrap() {
        this.clearFlags(65536);
    }

    private int setFlags(int flags) {
        int oldState;
        do {
            if (((oldState = this.state) & flags) != flags) continue;
            return oldState;
        } while (!stateUpdater.compareAndSet(this, oldState, oldState | flags));
        return oldState;
    }

    private int clearFlags(int flags) {
        int oldState;
        do {
            if (((oldState = this.state) & flags) != 0) continue;
            return oldState;
        } while (!stateUpdater.compareAndSet(this, oldState, oldState & ~flags));
        return oldState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataAvailable() {
        Object object = this.getUnwrapLock();
        synchronized (object) {
            try {
                return this.readBuffer.getResource().hasRemaining() || this.receiveBuffer.getResource().hasRemaining() && !this.isUnderflow();
            }
            catch (IllegalStateException ignored) {
                return false;
            }
        }
    }

    private final ByteBuffer getSendBuffer() {
        return this.expandedSendBuffer != null ? this.expandedSendBuffer : this.sendBuffer.getResource();
    }
}

