/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.circuitbreaker.sentinel;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.adapter.reactor.EntryConfig;
import com.alibaba.csp.sentinel.adapter.reactor.SentinelReactorTransformer;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveSentinelCircuitBreaker
implements ReactiveCircuitBreaker {
    private final String resourceName;
    private final EntryType entryType;
    private final List<DegradeRule> rules;

    public ReactiveSentinelCircuitBreaker(String resourceName, EntryType entryType, List<DegradeRule> rules) {
        Assert.hasText(resourceName, "resourceName cannot be blank");
        Assert.notNull(rules, "rules should not be null");
        this.resourceName = resourceName;
        this.entryType = entryType;
        this.rules = Collections.unmodifiableList(rules);
        this.applyToSentinelRuleManager();
    }

    public ReactiveSentinelCircuitBreaker(String resourceName, List<DegradeRule> rules) {
        this(resourceName, EntryType.OUT, rules);
    }

    public ReactiveSentinelCircuitBreaker(String resourceName) {
        this(resourceName, EntryType.OUT, Collections.emptyList());
    }

    private void applyToSentinelRuleManager() {
        if (this.rules == null || this.rules.isEmpty()) {
            return;
        }
        HashSet<DegradeRule> ruleSet = new HashSet<DegradeRule>(DegradeRuleManager.getRules());
        for (DegradeRule rule : this.rules) {
            if (rule == null) continue;
            rule.setResource(this.resourceName);
            ruleSet.add(rule);
        }
        DegradeRuleManager.loadRules(new ArrayList<DegradeRule>(ruleSet));
    }

    @Override
    public <T> Mono<T> run(Mono<T> toRun, Function<Throwable, Mono<T>> fallback) {
        Mono toReturn = toRun.transform(new SentinelReactorTransformer(new EntryConfig(this.resourceName, this.entryType)));
        if (fallback != null) {
            toReturn = toReturn.onErrorResume(fallback);
        }
        return toReturn;
    }

    @Override
    public <T> Flux<T> run(Flux<T> toRun, Function<Throwable, Flux<T>> fallback) {
        Flux toReturn = toRun.transform(new SentinelReactorTransformer(new EntryConfig(this.resourceName, this.entryType)));
        if (fallback != null) {
            toReturn = toReturn.onErrorResume(fallback);
        }
        return toReturn;
    }
}

